package com.mulesoft.extension.mq.internal.extension;

import com.mulesoft.extension.mq.internal.error.AnypointMQError;
import com.mulesoft.extension.mq.internal.config.AnypointMQConfiguration;
import com.mulesoft.extension.mq.api.exception.ResourceNotFoundException;
import com.mulesoft.extension.mq.internal.exception.AnypointMQExceptionHandler;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;

import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;

import static org.mule.runtime.api.meta.Category.SELECT;

/**
 * Anypoint MQ is a multi-tenant, cloud messaging service that enables customers to perform advanced
 * asynchronous messaging scenarios between their applications.
 */
@Extension(name = "Anypoint MQ", category = SELECT)
@Xml(prefix = "anypoint-mq")
@Export(classes = {ResourceNotFoundException.class, AnypointMqMessage.class})
@Configurations(AnypointMQConfiguration.class)
@OnException(AnypointMQExceptionHandler.class)
@ErrorTypes(AnypointMQError.class)
public class AnypointMQExtension {

}
