package com.mulesoft.extension.mq;

import static org.mule.runtime.core.api.util.UUID.getUUID;

import com.mulesoft.extension.mq.adminclient.AdminRestClient;
import com.mulesoft.extension.mq.rule.AnypointMQEnvironment;

import org.junit.rules.ExternalResource;

public class AnypointMQExtensionRule extends ExternalResource {

    private static final String SUBSCRIBER_QUEUE = "subscriberQueue";
    private AdminRestClient restClient = new AdminRestClient();

    @Override
    protected void before() {
        final AnypointMQEnvironment anypointMQEnvironment = new AnypointMQEnvironment();
        System.getProperties().put("providerUrl", anypointMQEnvironment.getProviderUrl());
        System.getProperties().put("clientId", anypointMQEnvironment.getClientId());
        System.getProperties().put("clientSecret", anypointMQEnvironment.getClientSecret());
        String subscriberQueueName = getUUID();
        restClient.createQueue(subscriberQueueName);
        System.getProperties().put(SUBSCRIBER_QUEUE, subscriberQueueName);
    }

    @Override
    protected void after() {
        final String queueName = (String) System.getProperties().get(SUBSCRIBER_QUEUE);
        restClient.deleteQueue(queueName);
    }
}
