package com.mulesoft.extension.mq.adminclient;

import com.google.common.collect.ImmutableMap;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Header;
import com.mulesoft.extension.mq.rule.AnypointMQEnvironment;

import java.io.Serializable;

import static com.jayway.restassured.RestAssured.given;
import static org.hamcrest.core.AnyOf.anyOf;
import static org.hamcrest.core.Is.is;

public class AdminRestClient
{

    private AnypointMQEnvironment anypointMQEnvironment = new AnypointMQEnvironment();
    private Header authorizationHeader;

    public void recreateQueue(String destination)
    {
        deleteQueue(destination);

        createQueue(destination);

    }

    public void deleteQueue(String queueUrl)
    {
        given()
                .header(getAuthorizationHeader())
                .when()
                .delete(getQueueUrl(queueUrl))
                .then()
                .statusCode(anyOf(is(204), is(404)));
    }

    private String getQueueUrl(String destination)
    {
        return String.format("%s/organizations/%s/environments/%s/regions/%s/destinations/queues/%s", anypointMQEnvironment.getAdminUrl(), anypointMQEnvironment.getOrganizationId(), anypointMQEnvironment.getEnvironmentId(), anypointMQEnvironment.getRegionId(), destination);
    }

    public void createQueue(String queueName)
    {
        given()
                .contentType(ContentType.JSON)
                .header(getAuthorizationHeader())
                .body(getQueueEntity())
                .when()
                .put(getQueueUrl(queueName))
                .then().statusCode(201);
    }

    private Header getAuthorizationHeader()
    {
        if (authorizationHeader == null)
        {
            String adminAccessToken = getAdminAccessToken();
            authorizationHeader = new Header("Authorization", "Bearer " + adminAccessToken);
        }
        return authorizationHeader;
    }

    private ImmutableMap<String, ? extends Serializable> getQueueEntity()
    {
        return ImmutableMap.of(
                "defaultTtl", 120000,
                "defaultLockTtl", 10000,
                "encrypted", false);
    }

    private String getAdminAccessToken()
    {
        return RestAssured.given()
                .contentType("application/x-www-form-urlencoded; charset=utf-8")
                .body(String.format("username=%s&password=%s", anypointMQEnvironment.getAdminUser(), anypointMQEnvironment.getAdminPassword()))
                .post(anypointMQEnvironment.getCoreServicesUrl() + "/accounts/login")
                .then().statusCode(200).extract().jsonPath().getString("access_token");
    }

}
