package com.mulesoft.extension.mq.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AnypointMQEnvironment
{

    private Properties anypointMqProperties;

    public AnypointMQEnvironment()
    {
        try
        {
            try (InputStream resourceAsStream = getClass().getClassLoader().getResourceAsStream("anypoint-mq.properties"))
            {
                anypointMqProperties = new Properties();
                anypointMqProperties.load(resourceAsStream);
            }
        } catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public String getAdminUrl()
    {
        return anypointMqProperties.getProperty("adminUrl");
    }

    public String getProviderUrl()
    {
        return anypointMqProperties.getProperty("providerUrl");
    }

    public String getClientId()
    {
        return anypointMqProperties.getProperty("clientId");
    }

    public String getClientSecret()
    {
        return anypointMqProperties.getProperty("clientSecret");
    }

    public Properties getProperties()
    {
        return anypointMqProperties;
    }

    public String getCoreServicesUrl()
    {
        return anypointMqProperties.getProperty("coreServicesUrl");
    }

    public String getAdminPassword()
    {
        return anypointMqProperties.getProperty("adminPassword");
    }

    public String getAdminUser()
    {
        return anypointMqProperties.getProperty("adminUser");
    }

    public String getOrganizationId()
    {
        return anypointMqProperties.getProperty("organizationId");
    }

    public String getEnvironmentId()
    {
        return anypointMqProperties.getProperty("environmentId");
    }

    public String getRegionId()
    {
        return anypointMqProperties.getProperty("region");
    }
}
