/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal;

import com.google.common.collect.ImmutableList;
import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.api.message.MessageContextFactory;
import com.mulesoft.extension.mq.internal.config.SubscriberConfiguration;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.AbstractCourierRestClient;
import com.mulesoft.mq.restclient.internal.ExecutorUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSubscriber.class);
    public static final long DEFAULT_POLLING_TIME = 1000L;
    public static final String DEFAULT_POLLING_TIME_STRING = "1000";
    private final MessageListener messageListener;
    private final MessageContextFactory messageContextFactory;
    protected final MQCircuitBreaker circuitBreaker;
    protected final Destination destination;
    protected final SubscriberConfiguration subscriberConfiguration;
    protected final ScheduledExecutorService executorService;
    protected boolean running;

    public AbstractSubscriber(SubscriberConfiguration subscriberConfiguration, Destination destination, MessageListener messageListener, MessageContextFactory messageContextFactory, MQCircuitBreaker circuitBreaker) {
        this.subscriberConfiguration = subscriberConfiguration;
        this.destination = destination;
        this.messageListener = messageListener;
        this.messageContextFactory = messageContextFactory;
        this.circuitBreaker = circuitBreaker;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public synchronized void start() {
        this.running = true;
        LOGGER.debug("Starting Subscriber");
        this.submitWork();
    }

    protected void submitWork() {
        if (this.running) {
            this.doSubmitWork();
        }
    }

    protected abstract void doSubmitWork();

    protected void handleError(Throwable e) {
        if (!AbstractCourierRestClient.isTimeout((Throwable)e)) {
            this.messageListener.onError(e);
        }
    }

    protected void processMessages(List<AnypointMqMessage> messages) {
        LOGGER.debug("Received messages count: {}", (Object)messages.size());
        this.processMessages(messages.iterator());
    }

    protected void processMessages(Iterator<AnypointMqMessage> messages) {
        if (this.running) {
            while (messages.hasNext()) {
                this.processMessage(messages.next());
            }
        } else {
            LOGGER.debug("Subscriber stopped, returning all local messages to the queue");
            this.nackAll(messages);
        }
    }

    protected void processMessage(AnypointMqMessage message) {
        AnypointMQMessageContext messageContext = this.messageContextFactory.createMessageContext(message, this.destination.getName());
        this.messageListener.onReceive(messageContext);
    }

    protected void nackAll(Iterator<AnypointMqMessage> messages) {
        this.nackAll((List<AnypointMqMessage>)ImmutableList.copyOf(messages));
    }

    protected void nackAll(List<AnypointMqMessage> messages) {
        if (!messages.isEmpty()) {
            this.destination.nack(messages).fireAndForget();
        }
    }

    public synchronized void stop() {
        this.running = false;
        LOGGER.debug("Stopping Subscriber");
        ExecutorUtils.stopExecutorService((ExecutorService)this.executorService);
    }
}

