/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.internal.DefaultMessageContextFactory;
import com.mulesoft.extension.mq.internal.client.MuleBasedAnypointMqClientFactory;
import com.mulesoft.mq.restclient.api.AnypointMqClient;
import com.mulesoft.mq.restclient.api.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpClient;

public class AnypointMQConnection {
    private DefaultMessageContextFactory messageContextFactory = new DefaultMessageContextFactory();
    private final AnypointMqClient client;
    private Scheduler ioScheduler;
    private HttpClient httpClient;

    public AnypointMQConnection(HttpClient httpClient, String url, String clientId, String clientSecret, Scheduler scheduler) {
        this.ioScheduler = scheduler;
        this.httpClient = httpClient;
        httpClient.start();
        this.client = new MuleBasedAnypointMqClientFactory(httpClient, scheduler).createClient(url, (CourierAuthenticationCredentials)new OAuthCredentials(clientId, clientSecret));
        this.client.init();
    }

    public void validate() {
    }

    public void disconnect() {
        this.client.dispose();
        this.ioScheduler.stop();
        this.httpClient.stop();
    }

    public Destination getDestination(String destination) {
        return (Destination)this.client.createDestinationLocator().getDestination(this.client.createDestinationLocator().getDefaultDestinationLocation(destination)).getValue();
    }

    public DefaultMessageContextFactory getMessageContextFactory() {
        return this.messageContextFactory;
    }
}

