/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.connection.ProxyParameterGroup;
import com.mulesoft.extension.mq.internal.connection.TcpClientSocketParameterGroup;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

public class AnypointMQConnectionProvider
implements CachedConnectionProvider<AnypointMQConnection> {
    @Parameter
    @Optional(defaultValue="https://mq-us-east-1.anypoint.mulesoft.com/api/v1")
    @DisplayName(value="URL")
    @Placement(order=1)
    @Example(value="https://mq-us-east-1.anypoint.mulesoft.com/api/v1")
    private String url;
    @Parameter
    @DisplayName(value="Client App ID")
    @Placement(order=2)
    private String clientId;
    @Parameter
    @Placement(order=3)
    @DisplayName(value="Client Secret")
    private String clientSecret;
    @Parameter
    @Placement(tab="TLS/SSL")
    @DisplayName(value="TLS Context")
    @Optional
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Placement(tab="Proxy")
    @Optional
    @NullSafe
    private ProxyParameterGroup proxyConfig;
    @Parameter
    @Placement(tab="Advanced")
    @DisplayName(value="TCP Client Socket Properties")
    @Optional
    @NullSafe
    private TcpClientSocketParameterGroup tcpClientSocketProperties;
    @Inject
    protected HttpService httpService;
    @Inject
    protected SchedulerService schedulerService;

    public AnypointMQConnection connect() throws ConnectionException {
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContextFactory).setProxyConfig(this.proxyConfig.toProxyConfig()).setClientSocketProperties(this.tcpClientSocketProperties.toTcpClientSocketProperties()).setName("amqHttpClient").build();
        HttpClient httpClient = this.httpService.getClientFactory().create(httpClientConfiguration);
        return new AnypointMQConnection(httpClient, this.url, this.clientId, this.clientSecret, this.schedulerService.ioScheduler());
    }

    public void disconnect(AnypointMQConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(AnypointMQConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (RuntimeException e) {
            return ConnectionValidationResult.failure((String)"An error occurred while validating the connection.", (Exception)e);
        }
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

