/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.server;

import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.internal.AbstractSubscriber;
import com.mulesoft.extension.mq.internal.PollingSubscriber;
import com.mulesoft.extension.mq.internal.PrefetchSubscriber;
import com.mulesoft.extension.mq.internal.config.AnypointMQConfiguration;
import com.mulesoft.extension.mq.internal.config.MQPrefetchConfiguration;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.server.ExtensionMessageListener;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.Optional;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQServer.class);
    private final AnypointMQConnection connection;
    private final SourceCallback<byte[], AnypointMQMessageContext> callback;
    private AbstractSubscriber subscriber;
    private ScheduledPrefetcher prefetcher;

    public AnypointMQServer(String destination, AnypointMQConfiguration config, AnypointMQConnection connection, SourceCallback<byte[], AnypointMQMessageContext> callback, MQCircuitBreaker circuitBreaker) {
        this.connection = connection;
        this.callback = callback;
        Destination courierDestination = connection.getDestination(destination);
        SubscriberAckMode ackMode = Optional.ofNullable(config.getAcknowledgementMode()).orElse(SubscriberAckMode.AUTO);
        int maxRedelivery = Optional.ofNullable(config.getMaxRedelivery()).orElse(-1);
        MQPrefetchConfiguration prefetch = config.getPrefetch();
        if (prefetch != null && prefetch.getFetchSize() > 0) {
            LOGGER.debug("Enabling prefetch");
            this.prefetcher = new ScheduledPrefetcher(courierDestination, prefetch.getFetchSize(), prefetch.getFetchTimeout(), Optional.ofNullable(config.getAcknowledgementTimeout()).orElse(120000L).longValue(), prefetch.getFrequency(), (MessagePreserver)new DefaultMessagePreserver(courierDestination, new TimeSupplier()), circuitBreaker);
            courierDestination = new PrefetchedDestination(courierDestination, (Prefetcher)this.prefetcher);
            this.subscriber = new PrefetchSubscriber(config, courierDestination, new ExtensionMessageListener(ackMode, maxRedelivery, courierDestination, this.callback), connection.getMessageContextFactory(), circuitBreaker);
        } else {
            LOGGER.debug("Enabling fixed polling");
            this.subscriber = new PollingSubscriber(config, courierDestination, new ExtensionMessageListener(ackMode, maxRedelivery, courierDestination, this.callback), connection.getMessageContextFactory(), circuitBreaker);
        }
    }

    public void start() {
        if (this.subscriber != null) {
            this.subscriber.start();
        }
        if (this.prefetcher != null) {
            this.prefetcher.start();
        }
    }

    public void stop() {
        this.connection.disconnect();
        if (this.prefetcher != null) {
            this.prefetcher.stop();
        }
        if (this.subscriber != null) {
            this.subscriber.stop();
        }
    }
}

