/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.server;

import com.mulesoft.extension.mq.api.message.AnypointMQMessageContext;
import com.mulesoft.extension.mq.internal.config.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.domain.MessageListener;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.exception.ResourceNotFoundException;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageListener.class);
    public static final String MESSAGE_CONTEXT_VAR = "MESSAGE_CONTEXT";
    public static final String DESTINATION_VAR = "DESTINATION";
    public static final String ACKNOWLEDGEMENT_MODE_VAR = "ACKNOWLEDGEMENT_MODE";
    private final SubscriberAckMode acknowledgementMode;
    private final Destination destination;
    private final SourceCallback<byte[], AnypointMQMessageContext> callback;
    private final int maxRedelivery;

    public ExtensionMessageListener(SubscriberAckMode acknowledgementMode, int maxRedelivery, Destination destination, SourceCallback<byte[], AnypointMQMessageContext> callback) {
        this.acknowledgementMode = acknowledgementMode;
        this.maxRedelivery = maxRedelivery;
        this.destination = destination;
        this.callback = callback;
    }

    @Override
    public void onReceive(AnypointMQMessageContext messageContext) {
        if (this.redeliveryExhausted(messageContext, this.maxRedelivery)) {
            LOGGER.debug("Listener Skipped Message '{}' - Max redelivery reached with '{}' attempts", (Object)messageContext.getMessage().getId(), (Object)messageContext.getMessage().getDeliveryCount());
            return;
        }
        if (this.acknowledgementMode == SubscriberAckMode.IMMEDIATE) {
            this.destination.ack(messageContext.getMessage()).fireAndForget();
        }
        LOGGER.debug("Message received - {}", (Object)messageContext.getMessage().getId());
        this.handleMessage(messageContext);
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof ResourceNotFoundException) {
            LOGGER.error("Connection failed - Destination not found: {}", (Object)this.destination);
            this.callback.onConnectionException(new ConnectionException(throwable));
        } else {
            LOGGER.error("Can not process received message.", throwable);
        }
    }

    private void handleMessage(AnypointMQMessageContext messageContext) {
        Map properties = messageContext.getMessage().getProperties();
        Result.Builder resultbuilder = Result.builder().output((Object)messageContext.getMessage().getBody()).attributes((Object)messageContext);
        if (properties.containsKey("contentType")) {
            resultbuilder.mediaType(MediaType.parse((String)((String)properties.get("contentType"))));
        }
        SourceCallbackContext callbackContext = this.callback.createContext();
        callbackContext.addVariable(ACKNOWLEDGEMENT_MODE_VAR, (Object)this.acknowledgementMode);
        callbackContext.addVariable(DESTINATION_VAR, (Object)this.destination);
        callbackContext.addVariable(MESSAGE_CONTEXT_VAR, (Object)messageContext);
        this.callback.handle(resultbuilder.build(), callbackContext);
        LOGGER.debug("Message dispatched - {}", (Object)messageContext.getMessage().getId());
    }

    private boolean redeliveryExhausted(AnypointMQMessageContext messageContext, int maxRedelivery) {
        int redeliveries;
        boolean exhausted = false;
        if (maxRedelivery >= 0 && (redeliveries = messageContext.getMessage().getDeliveryCount() - 1) > maxRedelivery) {
            exhausted = true;
        }
        return exhausted;
    }
}

