/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.api.message;

import com.mulesoft.extension.mq.api.message.MessageToDelete;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.Preconditions;

public class MessageBuilder {
    private MessageToDeleteImpl message = new MessageToDeleteImpl();

    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.message.properties.put(key, value);
        return this;
    }

    public MessageBuilder addHeader(String key, String value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.message.headers.put(key, value);
        return this;
    }

    public MessageBuilder setContent(byte[] content) {
        MessageToDeleteImpl.access$302(this.message, content);
        return this;
    }

    public MessageBuilder setMessageId(String messageId) {
        this.message.headers.put("messageId", messageId);
        return this;
    }

    public MessageBuilder setLockID(String lockId) {
        this.message.headers.put("lockId", lockId);
        return this;
    }

    public MessageBuilder setDestination(String destination) {
        this.message.headers.put("destination", destination);
        return this;
    }

    public MessageBuilder setMessageDeliveryCount(int messageDeliveryCount) {
        this.message.headers.put("deliveryCount", String.valueOf(messageDeliveryCount));
        return this;
    }

    public MessageToDelete build() {
        Preconditions.checkState((!this.message.properties.isEmpty() || this.message.getContent().isPresent() ? 1 : 0) != 0, (String)"Message cannot have empty content");
        return this.message;
    }

    public static class MessageToDeleteImpl
    implements MessageToDelete {
        private byte[] content = null;
        private Map<String, String> properties = new HashMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();

        private MessageToDeleteImpl() {
        }

        @Override
        public Optional<byte[]> getContent() {
            return Optional.ofNullable(this.content);
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        @Override
        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(this.headers);
        }

        @Override
        public Optional<Integer> getMessageDeliveryCount() {
            return Optional.of(Integer.valueOf(this.headers.get("deliveryCount")));
        }

        @Override
        public Optional<String> getMessageId() {
            return Optional.ofNullable(this.headers.get("messageId"));
        }

        @Override
        public Optional<String> getLockId() {
            return Optional.ofNullable(this.headers.get("lockId"));
        }

        @Override
        public Optional<String> getDestination() {
            return Optional.ofNullable(this.headers.get("destination"));
        }

        static /* synthetic */ byte[] access$302(MessageToDeleteImpl x0, byte[] x1) {
            x0.content = x1;
            return x1;
        }
    }
}

