/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.api.source;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.modes.SubscriberAckMode;
import com.mulesoft.extension.mq.api.source.MQSubscriber;
import com.mulesoft.extension.mq.api.source.SubscriberFactory;
import com.mulesoft.extension.mq.internal.PollingSubscriber;
import com.mulesoft.extension.mq.internal.server.ExtensionMessageListener;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="polling")
@DisplayName(value="Polling")
public class PollingTypeSubscriberFactory
implements SubscriberFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PollingTypeSubscriberFactory.class);
    private static final long DEFAULT_FREQUENCY = 1000L;
    private static final long DEFAULT_START_DELAY = 1000L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    @Parameter
    @Summary(value="Configures the scheduler that triggers the polling")
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Scheduler schedulingStrategy;

    public Scheduler getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public void setSchedulingStrategy(Scheduler schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    @Override
    public MQSubscriber createSubscriber(String subscriberName, Destination destination, SubscriberAckMode ackMode, long ackTimeout, MQCircuitBreaker circuitBreaker, SchedulerService schedulerService, SourceCallback<InputStream, AnypointMQMessageAttributes> callback) {
        LOGGER.debug("Enabling fixed polling for: " + subscriberName);
        this.initaliseStrategy();
        org.mule.runtime.api.scheduler.Scheduler executor = schedulerService.customScheduler(SchedulerConfig.config().withName(subscriberName).withMaxConcurrentTasks(1).withWaitAllowed(false));
        return new PollingSubscriber(ackMode, ackTimeout, destination, new ExtensionMessageListener(ackMode, destination, callback), circuitBreaker, executor, this.schedulingStrategy);
    }

    private void initaliseStrategy() {
        if (this.schedulingStrategy == null) {
            FixedFrequencyScheduler strategy = new FixedFrequencyScheduler();
            strategy.setTimeUnit(DEFAULT_TIME_UNIT);
            strategy.setFrequency(1000L);
            strategy.setStartDelay(1000L);
            this.schedulingStrategy = strategy;
        }
    }
}

