/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.api.config;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;

public class TcpClientSocketParameterGroup {
    public static final String BUFFER_CONFIGURATION = "Buffer Configuration";
    public static final String TIMEOUT_CONFIGURATION = "Timeout Configuration";
    @Parameter
    @Optional
    @Placement(tab="Buffer Configuration")
    @Summary(value="The size of the buffer (in bytes) used when sending data")
    private Integer sendBufferSize;
    @Parameter
    @Optional
    @Summary(value="The size of the buffer (in bytes) used when receiving data")
    private Integer receiveBufferSize;
    @Parameter
    @Optional
    @Summary(value="Time, in milliseconds, that the socket will wait in a blocking operation before failing")
    @Placement(tab="Timeout Configuration")
    private Integer clientTimeout;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Indicates whether the transmitted data should not be collected together for greater efficiency, and sent immediately")
    @DisplayName(value="Send TCP With No Delay")
    private boolean sendTcpNoDelay;
    @Parameter
    @Optional
    @Summary(value="This indicates for how long, in milliseconds, the socket will take to close so any remaining data istransmitted correctly")
    private Integer linger;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Indicates whether the open socket connections unused for a long period and with an unavailable connection should be closed")
    private boolean keepAlive;
    @Parameter
    @Optional(defaultValue="30000")
    @Placement(tab="Timeout Configuration")
    @Summary(value="Number of milliseconds to wait until an outbound connection to a remote server is successfully created, before failing with a timeout")
    private Integer connectionTimeout;

    public TcpClientSocketProperties toTcpClientSocketProperties() {
        return TcpClientSocketProperties.builder().sendBufferSize(this.sendBufferSize).receiveBufferSize(this.receiveBufferSize).clientTimeout(this.clientTimeout).sendTcpNoDelay(Boolean.valueOf(this.sendTcpNoDelay)).linger(this.linger).keepAlive(Boolean.valueOf(this.keepAlive)).connectionTimeout(this.connectionTimeout).build();
    }

    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public Integer getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(Integer clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    public boolean getSendTcpNoDelay() {
        return this.sendTcpNoDelay;
    }

    public void setSendTcpNoDelay(boolean sendTcpNoDelay) {
        this.sendTcpNoDelay = sendTcpNoDelay;
    }

    public Integer getLinger() {
        return this.linger;
    }

    public void setLinger(Integer linger) {
        this.linger = linger;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

