/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.source;

import com.mulesoft.extension.mq.api.circuit.CircuitBreakerConfiguration;
import com.mulesoft.mq.restclient.api.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.circuit.DefaultCircuitBreaker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MQCircuitsManager {
    private final Map<String, MQCircuitBreaker> circuits = new ConcurrentHashMap<String, MQCircuitBreaker>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQCircuitBreaker getOrCreateCircuit(CircuitBreakerConfiguration circuitConfig, String fallbackName) {
        String circuitName = circuitConfig.getCircuitName().orElse(fallbackName);
        MQCircuitBreaker circuit = this.createCircuit(circuitConfig, circuitName);
        Map<String, MQCircuitBreaker> map = this.circuits;
        synchronized (map) {
            MQCircuitBreaker existingCircuit = this.circuits.get(circuitName);
            if (existingCircuit == null) {
                this.circuits.put(circuitName, circuit);
            } else {
                if (!circuit.equals(existingCircuit)) {
                    throw new IllegalArgumentException(String.format("Two definitions of a circuit with same name [%s] but different configurations have been found. Either change the name of one circuit or use a single circuit configuration", circuitName));
                }
                circuit = existingCircuit;
            }
        }
        return circuit;
    }

    private MQCircuitBreaker createCircuit(CircuitBreakerConfiguration circuitConfig, String circuitName) {
        return new DefaultCircuitBreaker(circuitName, (String)circuitConfig.getOnErrorTypes().orElse(null), circuitConfig.getErrorsThreshold(), circuitConfig.getTripTimeout(), circuitConfig.getTripTimeoutUnit());
    }
}

