/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.internal.client.MuleBasedAnypointMQClientFactory;
import com.mulesoft.mq.restclient.api.AnypointMqClient;
import com.mulesoft.mq.restclient.api.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.DestinationLocation;
import com.mulesoft.mq.restclient.api.DestinationLocator;
import com.mulesoft.mq.restclient.impl.OAuthCredentials;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQConnection.class);
    private final AnypointMqClient client;
    private final DestinationLocator destinationLocator;
    private final Scheduler ioScheduler;
    private final HttpClient httpClient;

    public AnypointMQConnection(HttpClient httpClient, String url, String clientId, String clientSecret, String userAgentInfo, Scheduler scheduler) {
        LOGGER.debug("Initializing connection");
        this.ioScheduler = scheduler;
        this.httpClient = httpClient;
        httpClient.start();
        this.client = new MuleBasedAnypointMQClientFactory(httpClient, scheduler).createClient(url, (CourierAuthenticationCredentials)new OAuthCredentials(clientId, clientSecret), userAgentInfo);
        this.client.init();
        this.destinationLocator = this.client.createDestinationLocator();
    }

    public void validate() {
        this.client.validate();
    }

    public void disconnect() {
        LOGGER.debug("Requested to disconnect");
        this.client.dispose();
        this.ioScheduler.stop();
        this.httpClient.stop();
    }

    public Destination getDestination(String destination) {
        DestinationLocation location = this.destinationLocator.getDestinationLocation(destination);
        return this.destinationLocator.getDestination(location);
    }
}

