/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.server;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.modes.SubscriberAckMode;
import com.mulesoft.extension.mq.internal.server.MessageListener;
import com.mulesoft.mq.restclient.api.AnypointMQMessage;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.Lock;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.api.exception.MQClientConnectionException;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageListener.class);
    private final SubscriberAckMode acknowledgementMode;
    private final Destination destination;
    private final SourceCallback<InputStream, AnypointMQMessageAttributes> callback;

    public ExtensionMessageListener(SubscriberAckMode acknowledgementMode, Destination destination, SourceCallback<InputStream, AnypointMQMessageAttributes> callback) {
        this.acknowledgementMode = acknowledgementMode;
        this.destination = destination;
        this.callback = callback;
    }

    @Override
    public void onReceive(final AnypointMQMessage message) {
        LOGGER.debug("Message received with ID: {}", (Object)message.getMessageId());
        if (this.acknowledgementMode != SubscriberAckMode.IMMEDIATE) {
            this.handleMessage(message);
        } else {
            this.destination.ack(new Lock(message)).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

                public void onSuccess(MessageIdResult successValue) {
                    LOGGER.debug("Message acknowledged with ID: {}", (Object)message.getMessageId());
                    ExtensionMessageListener.this.handleMessage(message);
                }

                public void onError(Throwable e) {
                    String msg = String.format("ACK mode was set to IMMEDIATE for message with ID %s, but failed to do the acknowledge: %s", message.getMessageId(), e.getMessage());
                    LOGGER.error(msg, e);
                    LOGGER.debug("Message with ID {} will be skipped", (Object)message.getMessageId());
                }
            });
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (throwable instanceof MQClientConnectionException) {
            LOGGER.debug("Connection failed: {}", (Object)throwable.getMessage());
            this.callback.onConnectionException(new ConnectionException(throwable));
        } else {
            LOGGER.error("An error occurred while retrieving a messages", throwable);
        }
    }

    private void handleMessage(AnypointMQMessage message) {
        Map properties = message.getProperties();
        Result.Builder resultbuilder = Result.builder().output((Object)message.getBody()).attributes((Object)new AnypointMQMessageAttributes(this.destination.getName(), message, this.acknowledgementMode == SubscriberAckMode.MANUAL));
        if (properties.containsKey("contentType")) {
            resultbuilder.mediaType(MediaType.parse((String)((String)properties.get("contentType"))));
        }
        SourceCallbackContext callbackContext = this.callback.createContext();
        callbackContext.addVariable("ACKNOWLEDGEMENT_MODE", (Object)this.acknowledgementMode);
        callbackContext.addVariable("DESTINATION", (Object)this.destination);
        callbackContext.addVariable("MESSAGE", (Object)message);
        this.callback.handle(resultbuilder.build(), callbackContext);
        LOGGER.debug("Message dispatched with ID: {}", (Object)message.getMessageId());
    }
}

