/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.service;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessagePublishAttributes;
import com.mulesoft.extension.mq.api.exception.MQAckException;
import com.mulesoft.extension.mq.api.exception.MQConsumeException;
import com.mulesoft.extension.mq.api.exception.MQIllegalBodyException;
import com.mulesoft.extension.mq.api.exception.MQNackException;
import com.mulesoft.extension.mq.api.exception.MQPublishException;
import com.mulesoft.extension.mq.api.exception.MQTimeoutException;
import com.mulesoft.extension.mq.api.modes.ConsumerAckMode;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.model.AckToken;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessageBuilder;
import com.mulesoft.mq.restclient.client.mq.domain.Lock;
import com.mulesoft.mq.restclient.client.mq.domain.MessageIdResult;
import com.mulesoft.mq.restclient.exception.MQClientConnectionException;
import com.mulesoft.mq.restclient.exception.PayloadTooLargeException;
import com.mulesoft.mq.restclient.internal.CourierObserver;
import com.mulesoft.mq.restclient.internal.Destination;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQServiceClient.class);

    public static void ack(AnypointMQConnection connection, final AckToken token, final CompletionCallback<Void, Void> callback) {
        Lock lock = new Lock(token.getMessageId(), token.getLockId());
        connection.getDestination(token.getDestination()).ack(lock).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

            public void onSuccess(MessageIdResult successValue) {
                callback.success(Result.builder().build());
            }

            public void onError(Throwable e) {
                String msg = String.format("Failed to ACK the message with id '%s': %s", token.getMessageId(), e.getMessage());
                LOGGER.debug(msg, e);
                AnypointMQServiceClient.callOnError((Exception)((Object)new MQAckException(msg, e)), "ACK", callback);
            }
        });
    }

    public static void nack(AnypointMQConnection connection, final AckToken token, final CompletionCallback<Void, Void> callback) {
        Lock lock = new Lock(token.getMessageId(), token.getLockId());
        connection.getDestination(token.getDestination()).nack(lock).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

            public void onSuccess(MessageIdResult successValue) {
                callback.success(Result.builder().build());
            }

            public void onError(Throwable e) {
                String msg = String.format("Failed to NACK the message with id '%s': %s", token.getMessageId(), e.getMessage());
                LOGGER.debug(msg, e);
                AnypointMQServiceClient.callOnError((Exception)((Object)new MQNackException(msg, e)), "NACK", callback);
            }
        });
    }

    public static void consume(AnypointMQConnection connection, final String destination, final ConsumerAckMode acknowledgementMode, final Long pollingTime, Long acknowledgementTimeout, final CompletionCallback<InputStream, AnypointMQMessageAttributes> callback) {
        final Destination courierDestination = connection.getDestination(destination);
        courierDestination.receive(1, pollingTime.longValue(), acknowledgementTimeout.longValue()).subscribe((CourierObserver)new CourierObserver<List<AnypointMQMessage>>(){

            public void onSuccess(List<AnypointMQMessage> messages) {
                final Result.Builder resultBuilder = Result.builder();
                if (messages == null || messages.size() == 0) {
                    if (pollingTime > 0L) {
                        String msg = String.format("Failed to retrieve a Message. Didn't receive any message during polling interval of '%s' milliseconds", pollingTime);
                        LOGGER.debug(msg);
                        callback.error((Throwable)((Object)new MQTimeoutException(msg)));
                        return;
                    }
                    callback.success(resultBuilder.build());
                    return;
                }
                final AnypointMQMessage message = messages.get(0);
                resultBuilder.output((Object)message.getBody());
                if (message.getContentType() != null) {
                    resultBuilder.mediaType(MediaType.parse((String)message.getContentType()));
                }
                boolean requiresAckToken = acknowledgementMode == ConsumerAckMode.MANUAL;
                resultBuilder.attributes((Object)new AnypointMQMessageAttributes(destination, message, requiresAckToken));
                if (acknowledgementMode == ConsumerAckMode.IMMEDIATE) {
                    Lock lock = new Lock(message.getMessageId(), message.getLockId());
                    courierDestination.ack(lock).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

                        public void onSuccess(MessageIdResult successValue) {
                            callback.success(resultBuilder.build());
                        }

                        public void onError(Throwable e) {
                            String msg = String.format("Failed to perform the IMMEDIATE ACK of the message with id '%s': %s", message.getMessageId(), e.getMessage());
                            LOGGER.debug(msg, e);
                            AnypointMQServiceClient.callOnError((Exception)((Object)new MQAckException(msg, e)), "IMMEDIATE ACK", callback);
                        }
                    });
                    return;
                }
                callback.success(resultBuilder.build());
            }

            public void onError(Throwable e) {
                String msg = String.format("Failed to consume from destination '%s': %s", destination, e.getMessage());
                LOGGER.debug(msg, e);
                AnypointMQServiceClient.callOnError((Exception)((Object)new MQConsumeException(msg, e)), "CONSUME", callback);
            }
        });
    }

    public static void publish(StreamingHelper streamingHelper, AnypointMQConnection connection, final String destination, InputStream messageBodyStream, MediaType mediaType, String messageId, Optional<Long> deliveryDelay, boolean sendContentType, Optional<String> messageGroupId, Map<String, Object> properties, final CompletionCallback<InputStream, AnypointMQMessagePublishAttributes> callback) {
        final CursorStreamProvider stream = (CursorStreamProvider)streamingHelper.resolveCursorProvider((Object)messageBodyStream);
        AnypointMQMessage message = AnypointMQServiceClient.createMessage((InputStream)stream.openCursor(), sendContentType, mediaType.toString(), mediaType.getCharset(), messageId, properties, deliveryDelay, messageGroupId);
        connection.getDestination(destination).send(message).subscribe((CourierObserver)new CourierObserver<MessageIdResult>(){

            public void onSuccess(MessageIdResult result) {
                Result.Builder resultBuilder = Result.builder();
                resultBuilder.output((Object)stream.openCursor());
                resultBuilder.attributes((Object)new AnypointMQMessagePublishAttributes(result.getMessageId()));
                callback.success(resultBuilder.build());
            }

            public void onError(Throwable e) {
                String msg = String.format("Failed to publish message to destination '%s': %s", destination, e.getMessage());
                LOGGER.debug(msg, e);
                if (e instanceof PayloadTooLargeException) {
                    callback.error((Throwable)((Object)new MQIllegalBodyException(msg, e)));
                } else {
                    AnypointMQServiceClient.callOnError((Exception)((Object)new MQPublishException(msg, e)), "PUBLISH", callback);
                }
            }
        });
    }

    private static AnypointMQMessage createMessage(InputStream messageBody, boolean sendContentType, String mediaType, Optional<Charset> charset, String messageId, Map<String, Object> properties, Optional<Long> deliveryDelay, Optional<String> messageGroupId) {
        AnypointMQMessageBuilder messageBuilder = new AnypointMQMessageBuilder();
        messageBuilder.withBody(messageBody);
        String id = Optional.ofNullable(messageId).orElseGet(UUID::randomUUID).toString();
        messageBuilder.withMessageId(id);
        messageBuilder.withDeliveryDelay(deliveryDelay);
        messageBuilder.withMessageGroupId(messageGroupId);
        if (sendContentType) {
            messageBuilder.addProperty("contentType", (Object)mediaType);
            charset.map(Object::toString).ifPresent(value -> messageBuilder.addProperty("MULE_ENCODING", value));
        }
        if (properties != null) {
            messageBuilder.withProperties(properties);
        }
        return messageBuilder.build();
    }

    private static void callOnError(Exception exception, String actionName, CompletionCallback callback) {
        if (exception instanceof MQClientConnectionException || exception.getCause() instanceof MQClientConnectionException) {
            exception = new ConnectionException("Connection failed while executing [" + actionName + "]: " + exception.getMessage(), (Throwable)exception);
        }
        callback.error((Throwable)exception);
    }
}

