/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.stream;

import com.mulesoft.extension.mq.api.exception.AnypointMQError;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class LimitedSizeInputStream
extends InputStream {
    private final InputStream original;
    private final long maxSize;
    private long total;

    public LimitedSizeInputStream(InputStream original, long maxSize) {
        this.original = original;
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        int i = this.original.read();
        if (i >= 0) {
            this.incrementCounter(1);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.original.read(b, off, len);
        if (i >= 0) {
            this.incrementCounter(i);
        }
        return i;
    }

    private void incrementCounter(int size) {
        this.total += (long)size;
        if (this.total > this.maxSize) {
            String msg = String.format("InputStream exceeded maximum size of %s in bytes.", this.maxSize);
            throw new ModuleException(msg, (ErrorTypeDefinition)AnypointMQError.ILLEGAL_BODY);
        }
    }
}

