/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.api.source;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.modes.SubscriberAckMode;
import com.mulesoft.extension.mq.api.source.MQSubscriber;
import com.mulesoft.extension.mq.api.source.SubscriberFactory;
import com.mulesoft.extension.mq.internal.PrefetchSubscriber;
import com.mulesoft.extension.mq.internal.server.ExtensionMessageListener;
import com.mulesoft.mq.restclient.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.impl.DefaultMessagePreserver;
import com.mulesoft.mq.restclient.internal.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.impl.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.impl.TimeSupplier;
import java.io.InputStream;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="prefetch")
@DisplayName(value="Prefetch")
public class PrefetchTypeSubscriberFactory
implements SubscriberFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefetchTypeSubscriberFactory.class);
    private static final int KEEP_ALIVE_FREQUENCY = 5000;
    private static final int ACK_DEFAULT_MULTIPLIER = 4;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="30")
    @Summary(value="The maximum number of messages to be pre-fetched from the service and kept locally before dispatching to the flow")
    @DisplayName(value="Max Local Messages")
    private int maxLocalMessages;

    public int getMaxLocalMessages() {
        return this.maxLocalMessages;
    }

    public void setmaxLocalMessages(int maxLocalMessages) {
        this.maxLocalMessages = maxLocalMessages;
    }

    @Override
    public MQSubscriber createSubscriber(String subscriberName, Destination destination, SubscriberAckMode ackMode, long ackTimeout, MQCircuitBreaker circuitBreaker, SchedulerService schedulerService, SourceCallback<InputStream, AnypointMQMessageAttributes> callback, int primaryRegionStatusCheckIntervalMs, int fallbackMessagesCheckIntervalMs, boolean fallbackFeatureSystemPropertyEnabled) {
        LOGGER.debug("Enabling prefetch for: " + subscriberName);
        int circuitTtl = ackTimeout == 0L ? 480000 : (int)ackTimeout * 4;
        ScheduledPrefetcher prefetcher = new ScheduledPrefetcher(destination, this.maxLocalMessages, ackTimeout, 5000L, (MessagePreserver)new DefaultMessagePreserver(destination, new TimeSupplier()), circuitBreaker, circuitTtl, primaryRegionStatusCheckIntervalMs, fallbackMessagesCheckIntervalMs, fallbackFeatureSystemPropertyEnabled);
        PrefetchedDestination prefetchedDestination = new PrefetchedDestination(destination, (Prefetcher)prefetcher);
        return new PrefetchSubscriber(ackMode, ackTimeout, (Destination)prefetchedDestination, new ExtensionMessageListener(ackMode, (Destination)prefetchedDestination, callback), circuitBreaker, prefetcher);
    }
}

