/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.api.attributes;

import com.google.common.collect.ImmutableMap;
import com.mulesoft.extension.mq.internal.model.AckToken;
import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import java.io.Serializable;
import java.util.Map;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class AnypointMQMessageAttributes
implements Serializable {
    @Parameter
    private String destination;
    @Parameter
    private Map<String, Object> headers;
    @Parameter
    private Map<String, Object> properties;
    @Parameter
    private String messageId;
    @Parameter
    private int deliveryCount;
    @Parameter
    @Optional
    private String contentType;
    @Parameter
    @Optional
    private String ackToken;

    public AnypointMQMessageAttributes(String destination, AnypointMQMessage message, boolean createAckToken) {
        this.destination = destination;
        this.headers = message.getHeaders() == null ? ImmutableMap.of() : message.getHeaders();
        this.properties = message.getProperties() == null ? ImmutableMap.of() : message.getProperties();
        this.messageId = message.getMessageId();
        this.deliveryCount = message.getDeliveryCount();
        this.contentType = message.getContentType();
        if (createAckToken) {
            this.ackToken = new AckToken(destination, message.getMessageId(), message.getLockId()).getEncodedAckToken();
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getAckToken() {
        return this.ackToken;
    }

    public String toString() {
        return "AnypointMQMessageAttributes{destination='" + this.destination + '\'' + ", headers=" + this.headers + ", properties=" + this.properties + ", messageId='" + this.messageId + '\'' + ", deliveryCount=" + this.deliveryCount + ", contentType='" + this.contentType + '\'' + ", ackToken='" + this.ackToken + '\'' + '}';
    }
}

