/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.api.config.ProxyParameterGroup;
import com.mulesoft.extension.mq.api.config.TcpClientSocketParameterGroup;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.mq.restclient.client.Response;
import com.mulesoft.mq.restclient.exception.RestException;
import java.util.Properties;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQConnectionProvider
implements CachedConnectionProvider<AnypointMQConnection> {
    private static final String AMQ_HTTP_CLIENT = "amqHttpClient";
    private static final int FIRST_ORDER = 1;
    private static final int SECOND_ORDER = 2;
    private static final int THIRD_ORDER = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQConnectionProvider.class);
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String USER_AGENT_VERSION = "user-agent.version";
    private static final String USER_AGENT_MASK = "Mule Anypoint MQ/%s; Mule Version:%s";
    @Parameter
    @DisplayName(value="URL")
    @Placement(order=1)
    @Example(value="https://mq-us-east-1.anypoint.mulesoft.com/api/v1/organizations/<organization_id>/environments/<environment_id>")
    @Optional(defaultValue="https://mq-us-east-1.anypoint.mulesoft.com/api/v1/organizations/<organization_id>/environments/<environment_id>")
    @Summary(value="The region URL where the Queue resides. Obtain this URL from the Anypoint Platform > MQ")
    private String url;
    @Parameter
    @DisplayName(value="Client App ID")
    @Placement(order=2)
    @Summary(value="The Client App ID to be used. Obtain this ID from Anypoint Platform > MQ > Client Apps")
    private String clientId;
    @Parameter
    @Placement(order=3)
    @DisplayName(value="Client Secret")
    @Summary(value="The Client App Secret for the given Client App ID")
    private String clientSecret;
    @Parameter
    @Placement(tab="TLS/SSL")
    @DisplayName(value="TLS Context")
    @Optional
    private TlsContextFactory tlsContextFactory;
    @ParameterGroup(name="Proxy", showInDsl=true)
    @Placement(tab="Proxy")
    private ProxyParameterGroup proxyConfig;
    @ParameterGroup(name="TCP Client Socket Properties", showInDsl=true)
    @Placement(tab="Advanced")
    private TcpClientSocketParameterGroup tcpClientSocketProperties;
    @Inject
    protected HttpService httpService;
    @Inject
    protected SchedulerService schedulerService;
    private String userAgentInfo;

    public AnypointMQConnection connect() throws ConnectionException {
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContextFactory).setProxyConfig(this.proxyConfig.toProxyConfig()).setClientSocketProperties(this.tcpClientSocketProperties.toTcpClientSocketProperties()).setName(AMQ_HTTP_CLIENT).build();
        HttpClient httpClient = this.httpService.getClientFactory().create(httpClientConfiguration);
        try {
            return new AnypointMQConnection(httpClient, this.url, this.clientId, this.clientSecret, this.getUserAgentInfo(), this.schedulerService.ioScheduler());
        }
        catch (RestException e) {
            Response response = e.getResponse().orElse(null);
            if (response != null && (response.getStatusCode() >= 500 || response.getStatusCode() == 401)) {
                throw new ConnectionException(String.format("Failed to connect with Anypoint MQ Service: [%s] %s", response.getStatusCode(), response.getStatusText()), (Throwable)e);
            }
            throw e;
        }
    }

    public void disconnect(AnypointMQConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(AnypointMQConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)("An error occurred while validating the connection: " + e.getMessage()), (Exception)e);
        }
    }

    public String getUserAgentInfo() {
        if (this.userAgentInfo != null) {
            return this.userAgentInfo;
        }
        String mqVersion = null;
        try {
            Properties configuration = new Properties();
            configuration.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_PROPERTIES));
            mqVersion = configuration.getProperty(USER_AGENT_VERSION);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load User-Agent information: {}", (Object)e.getMessage());
        }
        this.userAgentInfo = String.format(USER_AGENT_MASK, mqVersion, MuleManifest.getProductVersion());
        return this.userAgentInfo;
    }
}

