/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.connection;

import com.mulesoft.extension.mq.internal.client.MuleBasedAnypointMQClientFactory;
import com.mulesoft.mq.restclient.AnypointMqClient;
import com.mulesoft.mq.restclient.client.mq.domain.CourierAuthenticationCredentials;
import com.mulesoft.mq.restclient.client.mq.domain.OAuthCredentials;
import com.mulesoft.mq.restclient.internal.Destination;
import com.mulesoft.mq.restclient.internal.DestinationLocation;
import com.mulesoft.mq.restclient.internal.DestinationLocator;
import com.mulesoft.mq.restclient.utils.UrlConversionUtils;
import java.util.Arrays;
import java.util.HashMap;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQConnection.class);
    private final AnypointMqClient client;
    private final DestinationLocator destinationLocator;
    private final Scheduler ioScheduler;
    private final HttpClient httpClient;
    private HashMap<String, Destination> destinationHashMap = new HashMap();

    public AnypointMQConnection(HttpClient httpClient, String url, String clientId, String clientSecret, String userAgentInfo, Scheduler scheduler) {
        LOGGER.debug("Initializing connection");
        LOGGER.info("Anypoint MQ Connector version " + userAgentInfo);
        this.ioScheduler = scheduler;
        this.httpClient = httpClient;
        httpClient.start();
        String fallbackUrl = UrlConversionUtils.getBackupRegionUrl((String)url, (boolean)false);
        LOGGER.debug("FALLBACK URL: " + fallbackUrl);
        this.client = new MuleBasedAnypointMQClientFactory(httpClient, scheduler).createClient(url, fallbackUrl, (CourierAuthenticationCredentials)new OAuthCredentials(clientId, clientSecret), userAgentInfo);
        this.client.init();
        this.destinationLocator = this.client.createDestinationLocator();
    }

    public void validate() {
        this.client.validate();
    }

    public void disconnect() {
        LOGGER.debug("Requested to disconnect");
        this.client.dispose();
        this.ioScheduler.stop();
        this.httpClient.stop();
    }

    public Destination getDestination(String destination) {
        LOGGER.debug("[CONNECTION] [getDestination] Getting destination for " + destination);
        LOGGER.debug("[CONNECTION] [getDestination] Entire destination hashmap: " + Arrays.asList(this.destinationHashMap));
        if (!this.destinationHashMap.containsKey(destination)) {
            LOGGER.debug("[CONNECTION] [getDestination] Destination object does not exist, creating new");
            DestinationLocation location = this.destinationLocator.getDestinationLocation(destination);
            this.destinationHashMap.put(destination, this.destinationLocator.getDestination(location));
        }
        LOGGER.debug("[CONNECTION] [getDestination] Found destination object: " + this.destinationHashMap.get(destination).toString());
        LOGGER.debug("[CONNECTION] [getDestination] Fallback configuration? " + this.destinationHashMap.get(destination).getFallbackConfiguration());
        return this.destinationHashMap.get(destination);
    }
}

