/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.operation;

import com.mulesoft.extension.mq.api.config.DelayTimeUnit;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AnypointMQMessageGroup {
    @Parameter
    @Content(primary=true)
    @Summary(value="The body of the Anypoint MQ Message")
    private TypedValue<InputStream> body;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Content
    @DisplayName(value="User Properties")
    @Summary(value="The custom user properties that should be set to this Message")
    private Map<String, Object> properties;
    @Parameter
    @Placement(tab="Advanced")
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="A custom ID for the outgoing Anypoint MQ Message. If absent, the broker will create one UUID for each message")
    @DisplayName(value="Message ID")
    private String messageId;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced")
    @Summary(value="The ID of the message group that the published message belongs to. Can only be specified for FIFO queues")
    @DisplayName(value="Message Group ID")
    private String messageGroupId;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced")
    @Summary(value="The delay, that will be applied to this message before it is consumed. Valid values are between 0 and 15 minutes.")
    @DisplayName(value="Delivery Delay")
    private Integer deliveryDelay;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced")
    @Summary(value="Time unit to be used in the deliveryDelay parameter configuration")
    @DisplayName(value="Delivery Delay Unit")
    private DelayTimeUnit deliveryDelayUnit;
    @Parameter
    @Placement(tab="Advanced")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    @Summary(value="Whether or not the body content type should be sent as a property")
    @DisplayName(value="Send Content-Type")
    private boolean sendContentType;

    public AnypointMQMessageGroup() {
    }

    public AnypointMQMessageGroup(TypedValue<InputStream> body, Map<String, Object> properties, String messageId, int deliveryDelay, DelayTimeUnit deliveryDelayUnit, String messageGroupId, boolean sendContentType) {
        this.body = body;
        this.properties = properties;
        this.messageId = messageId;
        this.deliveryDelay = deliveryDelay;
        this.deliveryDelayUnit = deliveryDelayUnit;
        this.sendContentType = sendContentType;
        this.messageGroupId = messageGroupId;
    }

    public TypedValue<InputStream> getBody() {
        return this.body;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Optional<Long> getDeliveryDelay() {
        return Optional.ofNullable(this.deliveryDelay).map(delay -> this.deliveryDelayUnit.toMillis(this.deliveryDelay.intValue()));
    }

    public Optional<String> getMessageGroupId() {
        return Optional.ofNullable(this.messageGroupId);
    }

    public boolean isSendContentType() {
        return this.sendContentType;
    }
}

