/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.server;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.modes.SubscriberAckMode;
import com.mulesoft.extension.mq.api.source.MQSubscriber;
import com.mulesoft.extension.mq.internal.config.SubscriberConfig;
import com.mulesoft.extension.mq.internal.fallback.FallbackSystemProperties;
import com.mulesoft.mq.restclient.circuit.MQCircuitBreaker;
import com.mulesoft.mq.restclient.internal.Destination;
import java.io.InputStream;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQServer.class);
    private MQSubscriber subscriber;

    public AnypointMQServer(SubscriberConfig subscriberConfig, Destination destination, SourceCallback<InputStream, AnypointMQMessageAttributes> callback, MQCircuitBreaker circuitBreaker, String subscriberName, SchedulerService schedulerService) {
        SubscriberAckMode ackMode = subscriberConfig.getAcknowledgementMode();
        long ackTimeout = subscriberConfig.getAcknowledgementTimeoutUnit().toMillis(subscriberConfig.getAcknowledgementTimeout());
        LOGGER.debug("Printing system properties");
        LOGGER.debug(String.valueOf(FallbackSystemProperties.getPrimaryRegionCheckIntervalMilliseconds()));
        LOGGER.debug(String.valueOf(FallbackSystemProperties.getFallbackMessagesCheckIntervalMilliseconds()));
        this.subscriber = subscriberConfig.getSubscriberType().createSubscriber(subscriberName, destination, ackMode, ackTimeout, circuitBreaker, schedulerService, callback, FallbackSystemProperties.getPrimaryRegionCheckIntervalMilliseconds(), FallbackSystemProperties.getFallbackMessagesCheckIntervalMilliseconds());
    }

    public void start() {
        LOGGER.debug("Starting Server");
        if (this.subscriber != null) {
            this.subscriber.start();
        }
    }

    public void stop() {
        LOGGER.debug("Stopping Server");
        if (this.subscriber != null) {
            this.subscriber.stop();
        }
    }
}

