/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.fallback;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FallbackSystemProperties {
    private static Integer primaryRegionCheckIntervalMilliseconds = null;
    private static Integer fallbackMessagesCheckIntervalMilliseconds = null;
    private static final String PRIMARY_REGION_CHECK_INTERVAL_PROPERTY_NAME = "PRIMARY_REGION_CHECK_INTERVAL_MILLISECONDS";
    private static final int PRIMARY_REGION_CHECK_INTERVAL_DEFAULT = 60000;
    private static final int PRIMARY_REGION_CHECK_INTERVAL_LOWEST = 5000;
    private static final int PRIMARY_REGION_CHECK_INTERVAL_HIGHEST = 600000;
    private static final String FALLBACK_MESSAGES_CHECK_INTERVAL_PROPERTY_NAME = "FALLBACK_MESSAGES_CHECK_INTERVAL_MILLISECONDS";
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_DEFAULT = 60000;
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_LOWEST = 5000;
    private static final int FALLBACK_MESSAGES_CHECK_INTERVAL_HIGHEST = 600000;
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackSystemProperties.class);

    private FallbackSystemProperties() {
    }

    private static boolean validateValueWithinRange(Integer value, int lowest, int highest) {
        return value != null && lowest <= value && value <= highest;
    }

    private static int fetchSystemProperty(String propertyName, int defaultValue, int lowest, int highest) {
        Integer propertyValue = null;
        try {
            Integer value = Integer.parseInt(System.getProperty(propertyName, String.valueOf(defaultValue)));
            if (FallbackSystemProperties.validateValueWithinRange(value, lowest, highest)) {
                propertyValue = value;
            }
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Error occurred while trying to fetch property %s, using default value (%s) instead: %s", propertyName, defaultValue, e.getMessage()));
        }
        return propertyValue != null ? propertyValue : defaultValue;
    }

    public static int getPrimaryRegionCheckIntervalMilliseconds() {
        if (primaryRegionCheckIntervalMilliseconds == null) {
            primaryRegionCheckIntervalMilliseconds = FallbackSystemProperties.fetchSystemProperty(PRIMARY_REGION_CHECK_INTERVAL_PROPERTY_NAME, 60000, 5000, 600000);
        }
        return primaryRegionCheckIntervalMilliseconds;
    }

    public static int getFallbackMessagesCheckIntervalMilliseconds() {
        if (fallbackMessagesCheckIntervalMilliseconds == null) {
            fallbackMessagesCheckIntervalMilliseconds = FallbackSystemProperties.fetchSystemProperty(FALLBACK_MESSAGES_CHECK_INTERVAL_PROPERTY_NAME, 60000, 5000, 600000);
        }
        return fallbackMessagesCheckIntervalMilliseconds;
    }
}

