/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.extension.mq.internal.operation;

import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessagePublishAttributes;
import com.mulesoft.extension.mq.api.exception.AnypointMQError;
import com.mulesoft.extension.mq.api.exception.MQAckException;
import com.mulesoft.extension.mq.api.exception.MQIllegalBodyException;
import com.mulesoft.extension.mq.api.exception.MQIllegalDeliveryDelay;
import com.mulesoft.extension.mq.api.exception.MQIllegalMessageGroupId;
import com.mulesoft.extension.mq.api.exception.MQNackException;
import com.mulesoft.extension.mq.api.modes.ConsumerAckMode;
import com.mulesoft.extension.mq.internal.connection.AnypointMQConnection;
import com.mulesoft.extension.mq.internal.error.AnypointMQAckErrorTypeProvider;
import com.mulesoft.extension.mq.internal.error.AnypointMQConsumeErrorTypeProvider;
import com.mulesoft.extension.mq.internal.error.AnypointMQNackErrorTypeProvider;
import com.mulesoft.extension.mq.internal.error.AnypointMQPublishErrorTypeProvider;
import com.mulesoft.extension.mq.internal.model.AckToken;
import com.mulesoft.extension.mq.internal.operation.AnypointMQMessageGroup;
import com.mulesoft.extension.mq.internal.service.AnypointMQServiceClient;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnypointMQOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnypointMQConnection.class);
    private static final Pattern GROUP_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9\\p{Punct}]{1,128}$");
    private static final int MAX_DELIVERY_DELAY = 900000;

    @MediaType(value="*/*", strict=false)
    @Throws(value={AnypointMQPublishErrorTypeProvider.class})
    public void publish(StreamingHelper streamingHelper, @Connection AnypointMQConnection connection, @DisplayName(value="Destination") @Summary(value="The name of the Queue or Exchange where the message should be published") String destination, @ParameterGroup(name="Message") AnypointMQMessageGroup messageGroup, CompletionCallback<InputStream, AnypointMQMessagePublishAttributes> callback) throws ConnectionException {
        messageGroup.getMessageGroupId().ifPresent(groupId -> {
            if (!GROUP_ID_PATTERN.matcher((CharSequence)groupId).matches()) {
                throw new MQIllegalMessageGroupId("The field messageGroupId can be up to 128 characters and must contain only alphanumeric characters and punctuation (!\"#$%&\\'()*+,-./:;<=>?@[\\\\]^_`{|}~) .");
            }
        });
        if (messageGroup.getBody() == null || messageGroup.getBody().getValue() == null) {
            throw new MQIllegalBodyException("The Body of the message cannot be 'null'");
        }
        messageGroup.getDeliveryDelay().ifPresent(deliveryDelay -> {
            if (deliveryDelay < 0L || deliveryDelay > 900000L) {
                throw new MQIllegalDeliveryDelay("Delivery delay must be within the range of 0 - 900000 milliseconds");
            }
        });
        org.mule.runtime.api.metadata.MediaType mediaType = messageGroup.getBody().getDataType().getMediaType();
        LOGGER.debug("TESTING OPERATIONS");
        AnypointMQServiceClient.publish(streamingHelper, connection, destination, (InputStream)messageGroup.getBody().getValue(), mediaType, messageGroup.getMessageId(), messageGroup.getDeliveryDelay(), messageGroup.isSendContentType(), messageGroup.getMessageGroupId(), messageGroup.getProperties(), callback);
    }

    @MediaType(value="*/*", strict=false)
    @Throws(value={AnypointMQConsumeErrorTypeProvider.class})
    public void consume(@Connection AnypointMQConnection connection, @DisplayName(value="Queue") @Summary(value="The name of the Queue from which to consume a message") String destination, @Summary(value="The Acknowledgement mode to use on the consumed message") @Optional(defaultValue="IMMEDIATE") ConsumerAckMode acknowledgementMode, @Summary(value="Duration that a message is held by a consumer waiting for an ACK or NACK, before returning to the Queue for redelivery") @Optional(defaultValue="0") long acknowledgementTimeout, @Summary(value="Time unit to be used in the acknowledgementTimeout configuration") @Optional(defaultValue="MILLISECONDS") TimeUnit acknowledgementTimeoutUnit, @Summary(value="How much time to be waited if the requested messages are not ready to be consumed") @Optional(defaultValue="10000") long pollingTime, @Summary(value="Time unit to be used in the pollingTime configuration") @Optional(defaultValue="MILLISECONDS") TimeUnit pollingTimeUnit, CompletionCallback<InputStream, AnypointMQMessageAttributes> callback) throws ConnectionException {
        if (acknowledgementTimeout < 0L) {
            String errorMessage = String.format("Acknowledgement timeout cannot be less than zero, but was `%s`", acknowledgementTimeout);
            throw new ModuleException(errorMessage, (ErrorTypeDefinition)AnypointMQError.CONSUMING);
        }
        acknowledgementTimeout = acknowledgementTimeoutUnit.toMillis(acknowledgementTimeout);
        if ((pollingTime = pollingTimeUnit.toMillis(pollingTime)) < 0L || pollingTime > 20000L) {
            String errorMessage = String.format("Polling time `%s` is not in the '0 to %s' milliseconds range", pollingTime, 20000L);
            throw new ModuleException(errorMessage, (ErrorTypeDefinition)AnypointMQError.CONSUMING);
        }
        AnypointMQServiceClient.consume(connection, destination, acknowledgementMode, pollingTime, acknowledgementTimeout, callback);
    }

    @Throws(value={AnypointMQAckErrorTypeProvider.class})
    public void ack(@Connection AnypointMQConnection connection, @Summary(value="The `ackToken` of the message, which was received when message was consumed") String ackToken, CompletionCallback<Void, Void> callback) throws ConnectionException {
        AckToken token;
        if (StringUtils.isBlank((String)ackToken)) {
            String errorMessage = ackToken == null ? "'null'" : "an empty String";
            throw new MQAckException("Invalid token: The 'ackToken' cannot be " + errorMessage);
        }
        try {
            token = AckToken.decodeAckToken(ackToken);
        }
        catch (Exception e) {
            String errorMessage = "The provided ackToken '" + ackToken + "' is invalid and could not be decoded: " + e.getMessage();
            throw new MQAckException(errorMessage, e);
        }
        AnypointMQServiceClient.ack(connection, token, callback);
    }

    @Throws(value={AnypointMQNackErrorTypeProvider.class})
    public void nack(@Connection AnypointMQConnection connection, @Summary(value="The `ackToken` of the message, which was received when message was consumed") String ackToken, CompletionCallback<Void, Void> callback) throws ConnectionException {
        AckToken token;
        if (StringUtils.isBlank((String)ackToken)) {
            String errorMessage = ackToken == null ? "'null'" : "an empty String";
            throw new MQNackException("Invalid token: The 'ackToken' cannot be " + errorMessage);
        }
        try {
            token = AckToken.decodeAckToken(ackToken);
        }
        catch (Exception e) {
            String errorMessage = "The provided ackToken '" + ackToken + "' is invalid and could not be decoded: " + e.getMessage();
            throw new MQNackException(errorMessage, e);
        }
        AnypointMQServiceClient.nack(connection, token, callback);
    }
}

