/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.enums.EncodingType;
import java.util.Map;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.api.util.MultiMap;

public class MimeHeaders
extends CaseInsensitiveMapWrapper<String> {
    public void setContentType(String contentType) {
        if (contentType != null) {
            this.put("Content-Type", contentType);
        }
    }

    public String getContentType() {
        return (String)this.get("Content-Type");
    }

    public void setContentTransferEncoding(EncodingType contentTransferEncoding) {
        if (contentTransferEncoding != null) {
            this.put("Content-Transfer-Encoding", contentTransferEncoding.getCanonicalName());
        }
    }

    public EncodingType getContentTransferEncoding() {
        return EncodingType.findByCanonicalName((String)this.get("Content-Transfer-Encoding"));
    }

    public void setContentId(String contentId) {
        if (contentId != null) {
            this.put("Content-ID", contentId);
        }
    }

    public String getContentId() {
        return (String)this.get("Content-ID");
    }

    public void setContentDescription(String contentDescription) {
        if (contentDescription != null) {
            this.put("Content-Description", contentDescription);
        }
    }

    public String getContentDescription() {
        return (String)this.get("Content-Description");
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition != null) {
            this.put("Content-Disposition", contentDisposition);
        }
    }

    public String getContentDisposition() {
        return (String)this.get("Content-Disposition");
    }

    public Map<String, String> getExtensionHeaders() {
        MultiMap extensionHeaders = new MultiMap();
        for (Map.Entry entry : this.entrySet()) {
            if (!this.isMimeExtensionHeader((String)entry.getKey())) continue;
            extensionHeaders.put(entry.getKey(), entry.getValue());
        }
        return extensionHeaders.toImmutableMultiMap();
    }

    public String put(String key, String value) {
        return (String)super.put(key, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            String key = entry.getKey();
            super.put(key, (Object)entry.getValue());
        }
    }

    private boolean isMimeExtensionHeader(String headerName) {
        return !"Content-Type".equalsIgnoreCase(headerName) && !"Content-Transfer-Encoding".equalsIgnoreCase(headerName) && !"Content-ID".equalsIgnoreCase(headerName) && !"Content-Description".equalsIgnoreCase(headerName);
    }
}

