/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.receive;

import com.mulesoft.connector.as2.internal.enums.RequiredSecurityLevel;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.ReceivedMessageInfo;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import java.io.InputStream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveAsyncMDNHandler
extends ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveAsyncMDNHandler.class);

    @Override
    public void receiveAS2Message(CaseInsensitiveMultiMap httpHeaders, InputStream content, AbstractReceiveAttributesBuilder attributesBuilder, RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, boolean doNonRepudiation, RequiredSecurityLevel requiredSecurityLevel) {
        callback.notifyReadyForOkHttpResponse();
        super.receiveAS2Message(httpHeaders, content, attributesBuilder, requestKeyStore, callback, doNonRepudiation, requiredSecurityLevel);
    }

    @Override
    protected void notifyResultMDN(RequestKeyStore requestKeyStore, ReceiveHandlerCallback callback, ReceivedMessageInfo messageInfo, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, boolean processed, MimePart receivedMimePart) {
        this.buildAndSetRequiredMDN(requestKeyStore, messageInfo, signedMimeMessageAttributes, dispositionType, processed);
        callback.notifyAsyncMDNResult(messageInfo.getContent(), signedMimeMessageAttributes, dispositionType, receivedMimePart);
    }

    @Override
    protected void addReceiptDeliveryOption(CaseInsensitiveMultiMap httpHeaders, MultiMap<String, String> mdnHeaders) {
        LOGGER.debug("MDN is Async so ReceiptDeliveryOption will be added.");
        LOGGER.debug("Checking recipient address for Async MDN");
        String receiptDeliveryOption = (String)httpHeaders.get((Object)"Receipt-Delivery-Option");
        if (!this.receiptDeliveryOptionMustStartWithHttp(receiptDeliveryOption)) {
            String errorMessage = "The Recipient-Address %s obtained from Receipt-Delivery-Option was invalid as it did not start with http";
            throw new AS2ExtensionException(String.format(errorMessage, receiptDeliveryOption), AS2ErrorType.MIME_PARSE);
        }
        mdnHeaders.put((Object)"Recipient-Address", (Object)receiptDeliveryOption);
        LOGGER.debug(String.format("The Async MDN recipient address is %s", receiptDeliveryOption));
    }

    private boolean receiptDeliveryOptionMustStartWithHttp(String receiptDeliveryOption) {
        return receiptDeliveryOption.toLowerCase().startsWith("http");
    }
}

