/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.mime;

import com.mulesoft.connector.as2.internal.crypto.AS2Digest;
import com.mulesoft.connector.as2.internal.mime.MimeHeaders;
import com.mulesoft.connector.as2.internal.stream.InputStreamResource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MimePart {
    private InputStream content;
    private MimeHeaders headers;
    private String boundaryIdentifier;
    private List<MimePart> mimeParts = new ArrayList<MimePart>();
    private AS2Digest as2Digest;
    private InputStreamResource inputStreamResource;

    public String getBoundaryIdentifier() {
        return this.boundaryIdentifier;
    }

    public void setBoundaryIdentifier(String boundaryIdentifier) {
        this.boundaryIdentifier = boundaryIdentifier;
    }

    public List<MimePart> getMimeParts() {
        return this.mimeParts;
    }

    public void setMimeParts(List<MimePart> mimeParts) {
        this.mimeParts = mimeParts;
    }

    public void addMimePart(MimePart mimePart) {
        if (this.mimeParts == null) {
            this.mimeParts = new ArrayList<MimePart>();
        }
        this.mimeParts.add(mimePart);
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setContent(InputStream content) {
        this.content = content;
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public boolean isMultiPart() {
        return this.mimeParts != null && this.mimeParts.size() > 0;
    }

    public AS2Digest getAs2Digest() {
        return this.as2Digest;
    }

    public void setAs2Digest(AS2Digest as2Digest) {
        this.as2Digest = as2Digest;
    }

    public boolean hasDigest() {
        return this.as2Digest != null;
    }

    public void setInputResource(InputStreamResource inputStreamResource) {
        this.inputStreamResource = inputStreamResource;
        this.setContent(inputStreamResource.asInputStream());
    }

    public void clearInputStreamResources() {
        if (this.mimeParts != null) {
            for (MimePart child : this.mimeParts) {
                child.clearInputStreamResources();
            }
        }
        if (this.inputStreamResource != null) {
            this.inputStreamResource.clearResource();
        }
        this.clearAditionalResource();
    }

    protected void clearAditionalResource() {
    }
}

