/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.codec;

import com.mulesoft.connectors.as2.internal.codec.Encoding;
import com.mulesoft.connectors.as2.internal.stream.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Base64;

public class MimeBase64Encoding
extends Encoding {
    static final byte[] CRLF = "\r\n".getBytes();
    static final int MIME_MAX_LINE_LENGTH = 76;
    static final int TOTAL_ENCODED_LINE_LENGTH = 76 + CRLF.length;
    private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    @Override
    public byte[] encode(PushbackInputStream inputStream) throws IOException {
        Buffer buffer = new Buffer(TOTAL_ENCODED_LINE_LENGTH);
        boolean endOfStream = false;
        while (!endOfStream && buffer.available() < 76) {
            byte[] bytesIn = new byte[3];
            int bytesread = this.readUntilByteArrayIsFull(bytesIn, inputStream);
            if (bytesread == -1) {
                endOfStream = true;
                continue;
            }
            if (bytesread == 3) {
                int bits = (bytesIn[0] & 0xFF) << 16 | (bytesIn[1] & 0xFF) << 8 | bytesIn[2] & 0xFF;
                buffer.load((byte)toBase64[bits >>> 18 & 0x3F]);
                buffer.load((byte)toBase64[bits >>> 12 & 0x3F]);
                buffer.load((byte)toBase64[bits >>> 6 & 0x3F]);
                buffer.load((byte)toBase64[bits & 0x3F]);
                if (buffer.available() < 76) continue;
                buffer.load(CRLF);
                continue;
            }
            int byteIn0 = bytesIn[0] & 0xFF;
            buffer.load((byte)toBase64[byteIn0 >> 2]);
            if (bytesread == 1) {
                buffer.load((byte)toBase64[byteIn0 << 4 & 0x3F]);
                buffer.load((byte)61);
                buffer.load((byte)61);
                continue;
            }
            if (bytesread != 2) continue;
            int byteIn1 = bytesIn[1] & 0xFF;
            buffer.load((byte)toBase64[byteIn0 << 4 & 0x3F | byteIn1 >> 4]);
            buffer.load((byte)toBase64[byteIn1 << 2 & 0x3F]);
            buffer.load((byte)61);
        }
        return buffer.readAll();
    }

    @Override
    public byte[] decode(PushbackInputStream inputStream) throws IOException {
        byte[] encodedLine = new byte[TOTAL_ENCODED_LINE_LENGTH];
        int bytesread = this.readUntilByteArrayIsFull(encodedLine, inputStream);
        if (bytesread <= 0) {
            return new byte[0];
        }
        encodedLine = bytesread < encodedLine.length ? Arrays.copyOf(encodedLine, bytesread) : Arrays.copyOf(encodedLine, 76);
        return Base64.getMimeDecoder().decode(encodedLine);
    }

    @Override
    public byte[] decode(String encoded) {
        return Base64.getMimeDecoder().decode(encoded);
    }

    int readUntilByteArrayIsFull(byte[] bytes, InputStream in) throws IOException {
        int bytesread = in.read(bytes);
        if (bytesread == bytes.length || bytesread == -1) {
            return bytesread;
        }
        while (bytesread < bytes.length) {
            int b = in.read();
            if (b < 0) {
                return bytesread;
            }
            bytes[bytesread] = (byte)b;
            ++bytesread;
        }
        return bytesread;
    }
}

