/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.DigestingInputStream;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import java.io.InputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.operator.bc.BcDigestProvider;

public class AS2Digest {
    private HashAlgorithm algorithm = HashAlgorithm.SHA1;
    private InputStream content;
    private Digest digest;
    private byte[] hash;
    private DigestingInputStream digestingInputStream;
    private BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    public AS2Digest initialise() {
        AlgorithmIdentifier id = new DefaultDigestAlgorithmIdentifierFinder().find(this.algorithm.algorithm());
        try {
            this.digest = new OneShotDigest((Digest)this.digestProvider.get(id));
            this.digestingInputStream = new DigestingInputStream(this.content, this);
        }
        catch (OperatorCreationException e) {
            throw new AS2ExtensionException("An error occurred while creating a digest", AS2ErrorType.SECURITY, e);
        }
        return this;
    }

    public DigestingInputStream getDigestingInputStream() {
        return this.digestingInputStream;
    }

    public byte[] getHash() {
        if (this.hash == null) {
            this.digest.doFinal(new byte[this.digest.getDigestSize()], 0);
        }
        return this.hash;
    }

    public AS2Digest withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public AS2Digest withAlgorithm(HashAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    Digest getDigest() {
        return this.digest;
    }

    static /* synthetic */ byte[] access$002(AS2Digest x0, byte[] x1) {
        x0.hash = x1;
        return x1;
    }

    private class OneShotDigest
    implements Digest {
        private final Digest wrappedDigest;
        private int doFinalReturnValue;

        public OneShotDigest(Digest wrappedDigest) {
            this.wrappedDigest = wrappedDigest;
        }

        public String getAlgorithmName() {
            return this.wrappedDigest.getAlgorithmName();
        }

        public int getDigestSize() {
            if (AS2Digest.this.hash == null) {
                return this.wrappedDigest.getDigestSize();
            }
            return AS2Digest.this.hash.length;
        }

        public void update(byte in) {
            if (AS2Digest.this.hash == null) {
                this.wrappedDigest.update(in);
            }
        }

        public void update(byte[] in, int inOff, int len) {
            if (AS2Digest.this.hash == null) {
                this.wrappedDigest.update(in, inOff, len);
            }
        }

        public int doFinal(byte[] out, int outOff) {
            if (AS2Digest.this.hash == null) {
                AS2Digest.access$002(AS2Digest.this, new byte[this.wrappedDigest.getDigestSize()]);
                this.doFinalReturnValue = this.wrappedDigest.doFinal(out, outOff);
                int i = 0;
                for (int j = outOff; i < AS2Digest.this.hash.length && j < out.length; ++i, ++j) {
                    ((AS2Digest)AS2Digest.this).hash[i] = out[j];
                }
            } else {
                int i = 0;
                for (int j = outOff; i < AS2Digest.this.hash.length && j < out.length; ++i, ++j) {
                    out[j] = AS2Digest.this.hash[i];
                }
            }
            return this.doFinalReturnValue;
        }

        public void reset() {
        }
    }
}

