/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Optional;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;

public class AS2Signature {
    private AS2Digest digest;
    private PrivateKey privateKey;
    private byte[] encryptedHash;

    public byte[] sign() {
        try {
            RSADigestSigner digestSigner = new RSADigestSigner(this.digest.getDigest());
            RSAPrivateCrtKey rsa = (RSAPrivateCrtKey)this.privateKey;
            digestSigner.init(true, (CipherParameters)new RSAKeyParameters(true, rsa.getModulus(), rsa.getPrivateExponent()));
            this.encryptedHash = digestSigner.generateSignature();
            return this.encryptedHash;
        }
        catch (CryptoException e) {
            throw new AS2ExtensionException("Signing of the Signature failed", AS2ErrorType.SECURITY, e);
        }
    }

    public AS2Signature withDigest(AS2Digest digest) {
        this.digest = digest;
        return this;
    }

    public AS2Signature withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public byte[] getEncryptedHash() {
        return Optional.ofNullable(this.encryptedHash).orElseThrow(() -> new AS2ExtensionException("sign() must be called first", AS2ErrorType.SECURITY));
    }
}

