/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DigestingInputStream
extends FilterInputStream {
    private AS2Digest digest;

    public DigestingInputStream(InputStream in, AS2Digest digest) {
        super(in);
        this.digest = digest;
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        if (i != -1) {
            this.digest.getDigest().update((byte)i);
        }
        return i;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int result = this.in.read(bytes, offset, length);
        if (result != -1) {
            this.digest.getDigest().update(bytes, offset, result);
        }
        return result;
    }

    public byte[] getDigestHash() {
        return this.digest.getHash();
    }
}

