/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.AS2Signature;
import com.mulesoft.connectors.as2.internal.crypto.PKCS7SignatureBlock;
import com.mulesoft.connectors.as2.internal.crypto.PKCS7SignatureBlockBuilder;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public class PKCS7SignatureBlockInputStream
extends InputStream {
    private PKCS7SignatureBlockBuilder pkcs7SignatureBlockBuilder = PKCS7SignatureBlock.builder();
    private List<AS2Signature> signatures = new ArrayList<AS2Signature>();
    private InputStream in;

    public PKCS7SignatureBlockInputStream withSignature(AS2Signature signature) {
        this.signatures.add(signature);
        return this;
    }

    public PKCS7SignatureBlockInputStream withCertificate(Certificate certificate) {
        this.pkcs7SignatureBlockBuilder.withCertificate(certificate);
        return this;
    }

    public PKCS7SignatureBlockInputStream withHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.pkcs7SignatureBlockBuilder.withHashAlgorithm(hashAlgorithm);
        return this;
    }

    private void initialiseInputStream() {
        if (this.in == null) {
            for (AS2Signature signature : this.signatures) {
                this.pkcs7SignatureBlockBuilder.withEncryptedHash(signature.sign());
            }
            PKCS7SignatureBlock pkcs7SignatureBlock = this.pkcs7SignatureBlockBuilder.build();
            this.in = new ByteArrayInputStream(pkcs7SignatureBlock.asn1EncodedPKCS7());
        }
    }

    @Override
    public int read() throws IOException {
        this.initialiseInputStream();
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.initialiseInputStream();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.initialiseInputStream();
        return this.in.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.initialiseInputStream();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.initialiseInputStream();
        return this.in.skip(n);
    }
}

