/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.DispositionType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMessageVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMessageVerifier.class);
    private PublicKey publicKey;

    public SignedMessageVerifier(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public boolean validateSignature(byte[] pkcs7Signature, AS2Digest as2Digest) {
        CMSSignedData cmsSignedData;
        LOGGER.info("Validating PKCS7 signature against digest");
        HashMap<String, byte[]> hashes = new HashMap<String, byte[]>();
        hashes.put(DigestFactory.getOID((String)as2Digest.getAlgorithm().algorithm()).getId(), as2Digest.getHash());
        try {
            cmsSignedData = new CMSSignedData(hashes, pkcs7Signature);
        }
        catch (CMSException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Unable to parse PKCS7 signature block", AS2ErrorType.SECURITY, e);
        }
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        if (signers.size() < 1) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Signature had no signer information!", AS2ErrorType.SECURITY);
        }
        for (SignerInformation signer : signers.getSigners()) {
            try {
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)new BouncyCastleProvider()).build(this.publicKey))) continue;
                return true;
            }
            catch (CMSException | OperatorCreationException e) {
                throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "Error verifying signature", AS2ErrorType.SECURITY, e);
            }
        }
        return false;
    }
}

