/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.enums;

public enum HashAlgorithm {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512"),
    UNSIGNED("UNSIGNED");

    private final String algorithm;

    private HashAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static HashAlgorithm findByAlgorithm(String algorithm) {
        for (HashAlgorithm hashAlgorithm : HashAlgorithm.values()) {
            if (!hashAlgorithm.algorithm.equalsIgnoreCase(algorithm) && !hashAlgorithm.name().equalsIgnoreCase(algorithm)) continue;
            return hashAlgorithm;
        }
        return null;
    }

    public String algorithm() {
        return this.algorithm;
    }
}

