/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.builder;

import com.mulesoft.connectors.as2.internal.enums.AS2Compression;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connectors.as2.internal.mime.builder.MimePartBuilder;
import com.mulesoft.connectors.as2.internal.stream.OutputTransformationInputStream;
import java.io.IOException;
import org.bouncycastle.cms.CMSCompressedDataStreamGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.operator.OutputCompressor;

public class CompressedMimePartBuilder
extends MimePartBuilder {
    public static final String PKCS7_COMPRESSED_DATA = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";
    public static final String ATTACHMENT_SMIME_P7Z = "attachment; filename=\"smime.p7z\"";
    public static final String SMIME_COMPRESSED_MESSAGE = "S/MIME Compressed Message";
    public static final String NOT_ABLE_TO_COMPRESS_MIMEPART = "not able to compress mimepart";
    private AS2Compression as2Compression;
    private MimePart mimePart;

    public CompressedMimePartBuilder withAS2CompressionAlg(AS2Compression as2Compression) {
        this.as2Compression = as2Compression;
        return this;
    }

    public CompressedMimePartBuilder withMimePart(MimePart mimePart) {
        this.mimePart = mimePart;
        return this;
    }

    @Override
    public MimePart build() {
        MimePart compressedMimePart = new MimePart();
        this.headers.setContentType(PKCS7_COMPRESSED_DATA);
        this.headers.setContentDisposition(ATTACHMENT_SMIME_P7Z);
        this.headers.setContentDescription(SMIME_COMPRESSED_MESSAGE);
        compressedMimePart.setHeaders(this.headers);
        MimePartInputStream mimePartInputStream = new MimePartInputStream(this.mimePart);
        CMSCompressedDataStreamGenerator gen = new CMSCompressedDataStreamGenerator();
        OutputTransformationInputStream inputStream = null;
        try {
            inputStream = new OutputTransformationInputStream(mimePartInputStream, outputStream -> gen.open(outputStream, (OutputCompressor)new ZlibCompressor()));
        }
        catch (IOException e) {
            throw new AS2ExtensionException(NOT_ABLE_TO_COMPRESS_MIMEPART, AS2ErrorType.COMPRESSION);
        }
        compressedMimePart.setContent(inputStream);
        return compressedMimePart;
    }
}

