/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.builder;

import com.mulesoft.connectors.as2.internal.enums.EncodingType;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.error.DispositionType;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.builder.ContentMimePartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.MDNMimePartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.MimeMultipartBuilder;
import java.io.ByteArrayInputStream;
import java.time.ZonedDateTime;

public class MDNReportMultiPartBuilder
extends MimeMultipartBuilder {
    private static final String TEXT_PLAIN = "text/plain";
    private String messageId;
    private String originalRecipient;
    private String finalRecipient;
    private String fileName;
    private byte[] originalMic;
    private HashAlgorithm originalMicAlg;
    private ZonedDateTime originalDate;
    private String fromName;
    private DispositionType dispositionType;

    public MDNReportMultiPartBuilder withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public MDNReportMultiPartBuilder withFromPartnerName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    public MDNReportMultiPartBuilder withOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
        return this;
    }

    public MDNReportMultiPartBuilder withFinalRecipient(String finalRecipient) {
        this.finalRecipient = finalRecipient;
        return this;
    }

    public MDNReportMultiPartBuilder withOriginalMic(byte[] originalMic) {
        this.originalMic = originalMic;
        return this;
    }

    public MDNReportMultiPartBuilder withOriginalMicAlg(HashAlgorithm originalMicAlg) {
        this.originalMicAlg = originalMicAlg;
        return this;
    }

    @Override
    public MDNReportMultiPartBuilder withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public MDNReportMultiPartBuilder withReceiveDate(ZonedDateTime originalDate) {
        this.originalDate = originalDate;
        return this;
    }

    public MDNReportMultiPartBuilder withDispositionType(DispositionType dispositionType) {
        this.dispositionType = dispositionType;
        return this;
    }

    @Override
    public MimePart build() {
        super.withContentType("multipart/report; report-type=disposition-notification");
        String status = this.dispositionType.getStatus();
        String mdnReplyContent = String.format("MDN for -\r\nMessage ID: %s\r\nFrom: %s\r\nTo: %s\r\nReceived on: %s\r\nStatus: %s\r\nComment: This is not a guarantee that the message has been completely processed or understood by the receiving translator\r\n", this.messageId, this.fromName, this.finalRecipient, this.originalDate, status);
        ByteArrayInputStream contentTxt = new ByteArrayInputStream(mdnReplyContent.getBytes());
        MimePart mdnTextPart = new ContentMimePartBuilder().withContent(contentTxt).withContentType(TEXT_PLAIN).withFileName(this.fileName).withContentTransferEncoding(EncodingType.SEVEN_BIT).build();
        super.withMimePart(mdnTextPart);
        MimePart mdn = new MDNMimePartBuilder().withMessageId(this.messageId).withDigest(this.originalMic).withDigestAlgorithm(this.originalMicAlg).withFinalRecipient(this.finalRecipient).withOriginalRecipient(this.originalRecipient).withDispositionType(this.dispositionType).build();
        super.withMimePart(mdn);
        return super.build();
    }
}

