/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.parse;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import com.mulesoft.connectors.as2.internal.crypto.DigestingInputStream;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connectors.as2.internal.mime.MimeHeaders;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.PKCS7MimePart;
import com.mulesoft.connectors.as2.internal.mime.SignedMimeMultipart;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeBoundaryAwareInputStream;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeParserController;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMimeMultipartParser
implements MimeContentParser<SignedMimeMultipart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedMimeMultipartParser.class);
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("boundary=\"([^\"]*)", 2);
    private static final Pattern MIC_ALG = Pattern.compile("micalg=([^; \t\r\n]*)", 2);
    private static final String CRLF = "\r\n";
    private static final String BOUNDARY_PREFIX = "\r\n--";
    private static final String BOUNDARY_SUFFIX = "--\r\n";

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("multipart/signed");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    @Override
    public SignedMimeMultipart parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) throws IOException {
        LOGGER.debug("Parsing Signed MIME Multipart");
        SignedMimeMultipart signedMimeMultiPart = new SignedMimeMultipart();
        signedMimeMultiPart.setHeaders(mimeHeaders);
        String boundaryIdentifier = this.getBoundaryIdentifierFromHeaders(mimeHeaders);
        signedMimeMultiPart.setBoundaryIdentifier(boundaryIdentifier);
        int boundaryEndPaddedLength = (BOUNDARY_PREFIX + boundaryIdentifier + BOUNDARY_SUFFIX).length();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(is, boundaryEndPaddedLength);
        HashAlgorithm hashAlgorithm = this.findDigestAlg(mimeHeaders);
        MimeBoundaryAwareInputStream content = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
        AS2Digest as2Digest = new AS2Digest().withContent(content).withAlgorithm(hashAlgorithm).initialise();
        DigestingInputStream signedContentInputStream = as2Digest.getDigestingInputStream();
        MimePart signedContentMimePart = mimeParserController.parse(signedContentInputStream);
        signedMimeMultiPart.addMimePart(signedContentMimePart);
        signedMimeMultiPart.setContentDigest(as2Digest);
        MimeBoundaryAwareInputStream signatureContentInputStream = new MimeBoundaryAwareInputStream(pushbackInputStream, boundaryIdentifier);
        MimePart signatureContentMimePart = mimeParserController.parse(signatureContentInputStream);
        signedMimeMultiPart.addMimePart(signatureContentMimePart);
        signedMimeMultiPart.setPkcs7Signature(((PKCS7MimePart)signatureContentMimePart).getPkcs7Bytes());
        LOGGER.debug("Finished parsing Signed MIME Multipart");
        return signedMimeMultiPart;
    }

    protected HashAlgorithm findDigestAlg(MimeHeaders mimeHeaders) {
        Matcher m = MIC_ALG.matcher(mimeHeaders.getContentType());
        if (m.find()) {
            String algorithm = m.group(1);
            if (algorithm.startsWith("\"")) {
                algorithm = algorithm.replaceAll("^\"|\"$", "");
            }
            return HashAlgorithm.findByAlgorithm(algorithm);
        }
        throw new AS2ExtensionException("Could not read the micalg in content type", AS2ErrorType.STREAM);
    }

    protected String getBoundaryIdentifierFromHeaders(MimeHeaders mimeHeaders) {
        Matcher m = BOUNDARY_PATTERN.matcher(mimeHeaders.getContentType());
        if (m.find()) {
            return m.group(1);
        }
        throw new AS2ExtensionException("Could not read the boundaryidentifier in content type", AS2ErrorType.STREAM);
    }
}

