/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.validate;

import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.validate.MimePartValidator;
import java.util.ArrayList;
import java.util.List;

public class MimeValidatorController {
    private List<MimePartValidator> mimePartValidators = new ArrayList<MimePartValidator>();

    public MimeValidatorController withValidator(MimePartValidator validator) {
        this.mimePartValidators.add(validator);
        return this;
    }

    public void validate(MimePart mimePart) {
        for (MimePartValidator validator : this.mimePartValidators) {
            if (mimePart.getHeaders() == null) {
                throw new AS2ExtensionException("Mime Headers are missing from Mime Part", AS2ErrorType.VALIDATE);
            }
            if (mimePart.getHeaders().getContentType() == null) {
                throw new AS2ExtensionException("No Content-Type header has been specified", AS2ErrorType.VALIDATE);
            }
            if (!validator.canValidate(mimePart.getHeaders().getContentType())) continue;
            validator.validate(mimePart);
        }
        if (mimePart.isMultiPart()) {
            for (MimePart childMimePart : mimePart.getMimeParts()) {
                this.validate(childMimePart);
            }
        }
    }
}

