/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.receive;

import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DispositionNotificationParser {
    Map<String, String> headers;
    private static final Pattern MIC_ALG_PATTERN = Pattern.compile("signed-receipt-micalg[ \t]*=[ \t]*(?<signedReceiptMicAlg>optional|required)[ \t]*,[ \t]*(?<micAlg>[^ \t\r\n]*)", 2);

    public DispositionNotificationParser(Map<String, String> headers) {
        this.headers = headers;
    }

    public HashAlgorithm signedReceiptMicAlg() {
        Matcher m;
        String dispositionNotificationOption = this.headers.get("Disposition-Notification-Options");
        if (dispositionNotificationOption != null && (m = MIC_ALG_PATTERN.matcher(dispositionNotificationOption)).find()) {
            String[] micAlgs;
            for (String micAlg : micAlgs = m.group("micAlg").split(",")) {
                HashAlgorithm algorithm = HashAlgorithm.findByAlgorithm(micAlg);
                if (algorithm == null) continue;
                return algorithm;
            }
        }
        return HashAlgorithm.UNSIGNED;
    }
}

