/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.receive;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.DispositionType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connectors.as2.internal.mime.MimeHeaders;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connectors.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connectors.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connectors.as2.internal.mime.builder.MDNReportMultiPartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connectors.as2.internal.mime.parse.EncryptedMimeParser;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connectors.as2.internal.mime.validate.MimeValidatorController;
import com.mulesoft.connectors.as2.internal.mime.validate.SignedMimeMultipartValidator;
import com.mulesoft.connectors.as2.internal.receive.DispositionNotificationParser;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiveHandler.class);
    private static final Pattern CONTENT_DISPOSITION = Pattern.compile("filename=[\"]?(?<fileName>[^\"]*)[\"]?", 2);
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();

    public ReceiveHandler withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public ReceiveHandler withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public String findFileName(Map<String, String> httpHeaders) {
        String fileName = null;
        String contentDisposition = httpHeaders.get("Content-Disposition");
        if (contentDisposition != null) {
            fileName = this.findFileName(contentDisposition);
        }
        return fileName;
    }

    public String findFileName(MimeHeaders mimeContentPartHeaders) {
        String fileName = null;
        if (mimeContentPartHeaders.containsKey("Content-Disposition")) {
            String contentDisposition = mimeContentPartHeaders.getContentDisposition();
            fileName = this.findFileName(contentDisposition);
        }
        return fileName;
    }

    public HashAlgorithm getMdnSigningAlgorithm(Map<String, String> httpHeaders) {
        DispositionNotificationParser parser = new DispositionNotificationParser(httpHeaders);
        return parser.signedReceiptMicAlg();
    }

    public MimePart buildMdn(PrivateKey selfPrivateKey, Certificate selfCertificate, CaseInsensitiveMultiMap httpHeaders, HashAlgorithm mdnSigningAlgorithm, AS2Digest as2Digest, DispositionType dispositionType, String fileName) {
        if (as2Digest == null) {
            return this.buildMdnMimePart(selfPrivateKey, selfCertificate, mdnSigningAlgorithm, null, null, dispositionType, fileName, httpHeaders);
        }
        byte[] digestHash = as2Digest.getHash();
        return this.buildMdnMimePart(selfPrivateKey, selfCertificate, mdnSigningAlgorithm, as2Digest.getAlgorithm(), digestHash, dispositionType, fileName, httpHeaders);
    }

    public MimePart parseReceivedMessage(Map<String, String> httpHeaders, InputStream receivedMessage, PrivateKey privateKey) {
        MimeParserController mimeParserController = new MimeParserController();
        if (privateKey != null) {
            mimeParserController.withContentParser(new EncryptedMimeParser().withPrivateKey(privateKey));
        }
        try {
            return mimeParserController.parse(httpHeaders, receivedMessage);
        }
        catch (IOException e) {
            String errorMessage = "Error parsing the received Content Stream";
            LOGGER.error(errorMessage);
            throw new AS2ExtensionException(errorMessage, AS2ErrorType.STREAM, e);
        }
    }

    public void validateReceivedMessageSignature(MimePart receivedMimePart, PublicKey storePublicKey) {
        SignedMimeMultipartValidator signedMimeMultipartValidator = new SignedMimeMultipartValidator().withPublicKey(storePublicKey);
        MimeValidatorController validatorController = new MimeValidatorController().withValidator(signedMimeMultipartValidator);
        validatorController.validate(receivedMimePart);
    }

    public MultiMap<String, String> getBasicMdnHttpHeaders(Map<String, String> headers) {
        if (headers == null) {
            headers = new MultiMap();
        }
        MultiMap<String, String> mdnHeaders = new MultiMap<String, String>();
        mdnHeaders = this.getCommonAS2HttpHeaders(mdnHeaders, (String)headers.get("AS2-From"), (String)headers.get("AS2-To"));
        mdnHeaders.put((Object)"Subject", (Object)String.format("Message Received MDN Response for ID %s", mdnHeaders.get((Object)"Message-ID")));
        return mdnHeaders;
    }

    public MultiMap generateMDNHeaders(CaseInsensitiveMultiMap httpHeaders, MimePart mdnReportMultiPart) {
        MultiMap<String, String> mdnHeaders = new MultiMap<String, String>();
        mdnReportMultiPart.getHeaders().forEach((arg_0, arg_1) -> ((MultiMap)mdnHeaders).put(arg_0, arg_1));
        mdnHeaders = this.getCommonAS2HttpHeaders(mdnHeaders, (String)httpHeaders.get((Object)"AS2-From"), (String)httpHeaders.get((Object)"AS2-To"));
        mdnHeaders.put((Object)"Subject", (Object)String.format("Message Received MDN Response for ID %s", mdnHeaders.get((Object)"Message-ID")));
        if (this.isAsyncMdnRequested(httpHeaders)) {
            String deliveryAddress = (String)httpHeaders.get((Object)"Receipt-Delivery-Option");
            if (deliveryAddress.toLowerCase().startsWith("http")) {
                mdnHeaders.put((Object)"Recipient-Address", (Object)deliveryAddress);
                LOGGER.info(String.format("The Async MDN recipient address is %s", deliveryAddress));
            } else {
                String errorMessage = "The Recipient-Address %s obtained from Receipt-Delivery-Option was invalid as it did not start with http";
                throw new AS2ExtensionException(String.format(errorMessage, deliveryAddress), AS2ErrorType.VALIDATE);
            }
        }
        return mdnHeaders;
    }

    MimePart buildMdnMimePart(PrivateKey selfPrivateKey, Certificate selfCertificate, HashAlgorithm mdnSigningAlgorithm, HashAlgorithm originalMsgAS2DigestAlgorithm, byte[] originalMsgAS2DigestHash, DispositionType dispositionType, String fileName, CaseInsensitiveMultiMap httpHeaders) {
        String recipient = (String)httpHeaders.get((Object)"AS2-To");
        MimePart multipartReport = new MDNReportMultiPartBuilder().withFileName(fileName).withMessageId((String)httpHeaders.get((Object)"Message-ID")).withFromPartnerName((String)httpHeaders.get((Object)"AS2-From")).withOriginalRecipient(recipient).withFinalRecipient(recipient).withReceiveDate(ZonedDateTime.now()).withDispositionType(dispositionType).withOriginalMic(originalMsgAS2DigestHash).withOriginalMicAlg(originalMsgAS2DigestAlgorithm).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
        if (selfCertificate != null && selfPrivateKey != null && mdnSigningAlgorithm != HashAlgorithm.UNSIGNED) {
            HashAlgorithm mdnSigningHashAlgorithm = null;
            if (mdnSigningAlgorithm != null) {
                mdnSigningHashAlgorithm = HashAlgorithm.findByAlgorithm(mdnSigningAlgorithm.algorithm());
            }
            return this.getSignedMultipartReport(selfPrivateKey, selfCertificate, mdnSigningHashAlgorithm, multipartReport);
        }
        return multipartReport;
    }

    public boolean isMdnRequired(MultiMap<String, String> httpHeaders) {
        return httpHeaders.get((Object)"Disposition-Notification-To") != null;
    }

    private AS2MessageIdGeneratorFactory getAs2MessageIdGeneratorFactory() {
        return this.as2MessageIdGeneratorFactory;
    }

    private MimePart getSignedMultipartReport(PrivateKey selfPrivateKey, Certificate selfCertificate, HashAlgorithm mdnSigningAlgorithm, MimePart multipartReport) {
        AS2Digest as2Digest = new AS2Digest().withContent(new MimePartInputStream(multipartReport)).withAlgorithm(mdnSigningAlgorithm).initialise();
        return new SignedMimeMultipartBuilder().withPrivateKey(selfPrivateKey).withSelfCertificate(selfCertificate).withDigest(as2Digest).withMimePart(multipartReport).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
    }

    private MultiMap<String, String> getCommonAS2HttpHeaders(MultiMap<String, String> mdnHeaders, String as2From, String as2To) {
        String receiver = as2From;
        String sender = as2To;
        mdnHeaders.put((Object)"Mime-Version", (Object)"1.0");
        mdnHeaders.put((Object)"AS2-To", (Object)receiver);
        mdnHeaders.put((Object)"AS2-From", (Object)sender);
        mdnHeaders.put((Object)"Message-ID", (Object)this.getAs2MessageIdGeneratorFactory().getInstance().generateMessageId(sender, receiver));
        return mdnHeaders;
    }

    private boolean isAsyncMdnRequested(CaseInsensitiveMultiMap httpHeaders) {
        return httpHeaders.containsKey((Object)"Receipt-Delivery-Option");
    }

    private String findFileName(String contentDisposition) {
        String fileName = null;
        Matcher fileNameMatcher = CONTENT_DISPOSITION.matcher(contentDisposition);
        if (fileNameMatcher.find()) {
            fileName = fileNameMatcher.group("fileName");
        }
        return fileName;
    }
}

