/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.send;

import com.mulesoft.connectors.as2.internal.crypto.AS2Digest;
import com.mulesoft.connectors.as2.internal.enums.AS2Compression;
import com.mulesoft.connectors.as2.internal.enums.EncodingType;
import com.mulesoft.connectors.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.enums.RequestReceipt;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.MimePartInputStream;
import com.mulesoft.connectors.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connectors.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connectors.as2.internal.mime.builder.CompressedMimePartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.ContentMimePartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.EncryptedMimePartBuilder;
import com.mulesoft.connectors.as2.internal.mime.builder.SignedMimeMultipartBuilder;
import com.mulesoft.connectors.as2.internal.stream.InputStreamResource;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MessageBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2MessageBuilder.class);
    static final String AS2_VERSION = "1.1";
    static final String AS2_VERSION_HEADER = "AS2-Version";
    static final String MESSAGE_ID_HEADER = "Message-ID";
    static final String MIME_VERSION_HEADER = "Mime-Version";
    static final String MIME_VERSION = "1.0";
    static final String AS2_FROM_HEADER = "AS2-From";
    static final String AS2_TO_HEADER = "AS2-To";
    static final String DISPOSITION_NOTIFICATION_TO = "Disposition-Notification-To";
    static final String DISPOSITION_NOTIFICATION_OPTIONS = "Disposition-notification-options";
    static final String RECEIPT_DELIVERY_OPTION = "Receipt-delivery-option";
    private String mimeType;
    private String fileName;
    private String contentDescription;
    private EncodingType contentTransferEncoding;
    private HashAlgorithm hashAlgorithm;
    private HashAlgorithm mdnHashAlgorithm;
    private EncryptionAlgorithm encryptionAlgorithm;
    private PrivateKey privateKey;
    private Certificate selfCertificate;
    private Certificate partnerCertificate;
    private InputStream content;
    private String sender;
    private String senderEmail;
    private String receiver;
    private String receiptDeliveryOption;
    private RequestReceipt requestRequiresReceipt;
    private AS2Compression as2Compression;
    private InputStreamResource bodyResource;
    private AS2Digest as2Digest;
    private MultiMap<String, String> headers;
    private BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    private AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();

    public static String getMessageIdHeader() {
        return MESSAGE_ID_HEADER;
    }

    public AS2MessageBuilder withBoundaryIdentifierGeneratorFactory(BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory) {
        this.boundaryIdentifierGeneratorFactory = boundaryIdentifierGeneratorFactory;
        return this;
    }

    public AS2MessageBuilder withAS2MessageIdGeneratorFactory(AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory) {
        this.as2MessageIdGeneratorFactory = as2MessageIdGeneratorFactory;
        return this;
    }

    public AS2MessageBuilder withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public AS2MessageBuilder withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public AS2MessageBuilder withContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
        return this;
    }

    public AS2MessageBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public AS2MessageBuilder withContentTransferEncoding(EncodingType encoding) {
        this.contentTransferEncoding = encoding;
        return this;
    }

    public AS2MessageBuilder withSignatureHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public AS2MessageBuilder withMdnSignatureHashAlgorithm(HashAlgorithm mdnHashAlgorithm) {
        this.mdnHashAlgorithm = mdnHashAlgorithm;
        return this;
    }

    public AS2MessageBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public AS2MessageBuilder withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public AS2MessageBuilder withSelfCertificate(Certificate certificate) {
        this.selfCertificate = certificate;
        return this;
    }

    public AS2MessageBuilder withPartnerCertificate(Certificate certificate) {
        this.partnerCertificate = certificate;
        return this;
    }

    public AS2MessageBuilder withSender(String sender) {
        this.sender = sender;
        return this;
    }

    public AS2MessageBuilder withRespondToEmail(String senderEmail) {
        this.senderEmail = senderEmail;
        return this;
    }

    public AS2MessageBuilder withReceiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    public AS2MessageBuilder withReceiptRequired(RequestReceipt requestReceipt) {
        this.requestRequiresReceipt = requestReceipt;
        return this;
    }

    public AS2MessageBuilder withCompression(AS2Compression compression) {
        this.as2Compression = compression;
        return this;
    }

    public AS2MessageBuilder withReceiptDeliveryOption(String receiptDeliveryOption) {
        this.receiptDeliveryOption = receiptDeliveryOption;
        return this;
    }

    public AS2MessageBuilder build() {
        MimePart message = this.createUnsignedMimePart();
        if (this.hashAlgorithm != null && this.hashAlgorithm != HashAlgorithm.UNSIGNED) {
            message = this.createSignedMimePart(message);
        }
        if (this.as2Compression != null && this.as2Compression != AS2Compression.NONE) {
            message = this.createCompressedMimePart(message);
        }
        if (this.encryptionAlgorithm != null && this.encryptionAlgorithm != EncryptionAlgorithm.UNENCRYPTED) {
            message = this.createEncryptedMimePart(message);
        }
        this.saveBody(message);
        this.headers = new MultiMap();
        this.headers.put((Object)MIME_VERSION_HEADER, (Object)MIME_VERSION);
        this.headers.put((Object)AS2_VERSION_HEADER, (Object)AS2_VERSION);
        this.headers.put((Object)AS2_FROM_HEADER, (Object)(this.sender != null && this.sender.contains(" ") ? "\"" + this.sender + "\"" : this.sender));
        this.headers.put((Object)AS2_TO_HEADER, (Object)(this.receiver != null && this.receiver.contains(" ") ? "\"" + this.receiver + "\"" : this.receiver));
        this.headers.put((Object)MESSAGE_ID_HEADER, (Object)this.as2MessageIdGeneratorFactory.getInstance().generateMessageId(this.sender, this.receiver));
        this.headers.putAll((Map)((Object)message.getHeaders()));
        this.setReceiptHeaders((Map<String, String>)this.headers);
        return this;
    }

    public InputStream getBody() {
        return this.bodyResource.asInputStream();
    }

    public AS2Digest getDigest() {
        return this.as2Digest;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    void setReceiptHeaders(Map<String, String> headers) {
        if (this.requestRequiresReceipt != RequestReceipt.NONE) {
            headers.put(DISPOSITION_NOTIFICATION_TO, this.senderEmail);
        }
        if (this.requestRequiresReceipt == RequestReceipt.SIGNED_OPTIONAL || this.requestRequiresReceipt == RequestReceipt.SIGNED_REQUIRED) {
            if (this.mdnHashAlgorithm == HashAlgorithm.UNSIGNED || this.mdnHashAlgorithm == null) {
                LOGGER.warn("Requesting a signed receipt without providing an explicit algorithm in sender configuration. Using SHA-1 by default.");
                this.mdnHashAlgorithm = this.getDefaultAlgorithm();
            }
            headers.put(DISPOSITION_NOTIFICATION_OPTIONS, String.format("signed-receipt-protocol=required,pkcs7-signature; signed-receipt-micalg=optional,%s", this.mdnHashAlgorithm.name()));
        }
        if (!StringUtils.isBlank((String)this.receiptDeliveryOption)) {
            LOGGER.info("Applying the A-Sync MDN request header: receipt-delivery-option");
            headers.put(RECEIPT_DELIVERY_OPTION, this.receiptDeliveryOption);
        }
    }

    private MimePart createUnsignedMimePart() {
        return new ContentMimePartBuilder().withDefaultDisposition().withContentType(this.mimeType).withFileName(this.fileName).withContentDescription(this.contentDescription).withContentTransferEncoding(this.contentTransferEncoding).withContent(this.content).build();
    }

    private MimePart createSignedMimePart(MimePart contentMimePart) {
        this.as2Digest = new AS2Digest().withContent(new MimePartInputStream(contentMimePart)).withAlgorithm(this.hashAlgorithm).initialise();
        return new SignedMimeMultipartBuilder().withPrivateKey(this.privateKey).withSelfCertificate(this.selfCertificate).withDigest(this.as2Digest).withMimePart(contentMimePart).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).build();
    }

    private MimePart createEncryptedMimePart(MimePart mimePart) {
        return new EncryptedMimePartBuilder().withEncryptionAlgorithm(this.encryptionAlgorithm).withCertificate((X509Certificate)this.partnerCertificate).withMimePart(mimePart).build();
    }

    private MimePart createCompressedMimePart(MimePart mimePart) {
        return new CompressedMimePartBuilder().withAS2CompressionAlg(this.as2Compression).withMimePart(mimePart).build();
    }

    void saveBody(MimePart message) {
        this.bodyResource = InputStreamResource.saveToResource(message.getContent());
    }

    private HashAlgorithm getDefaultAlgorithm() {
        return HashAlgorithm.SHA1;
    }
}

