/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.stream;

import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mule.runtime.core.api.util.IOUtils;

public abstract class InputStreamResource {
    public static InputStreamResource saveToResource(InputStream inputStream) {
        return new CachedInputStreamResource(inputStream);
    }

    public abstract InputStream asInputStream();

    public static class CachedInputStreamResource
    extends InputStreamResource {
        public static final String PROPERTY_BASE_PATH = "com.mulesoft.connectors.as2.";
        private static final int DEFAULT_THRESHOLD;
        private static final File TEMP_FILE_DIR;
        private File fileResource;
        private byte[] arrayResource;

        public CachedInputStreamResource(InputStream is) {
            if (DEFAULT_THRESHOLD == -1) {
                this.arrayResource = IOUtils.toByteArray((InputStream)is);
            } else {
                try {
                    this.arrayResource = new byte[DEFAULT_THRESHOLD];
                    int pos = 0;
                    int i = is.read();
                    while (i != -1 && pos < DEFAULT_THRESHOLD) {
                        this.arrayResource[pos++] = (byte)i;
                        i = is.read();
                    }
                    if (i != -1) {
                        this.fileResource = TEMP_FILE_DIR == null ? File.createTempFile("as2", "tmp") : File.createTempFile("as2", "tmp", TEMP_FILE_DIR);
                        this.fileResource.deleteOnExit();
                        FileOutputStream os = new FileOutputStream(this.fileResource);
                        IOUtils.copyLarge((InputStream)new ByteArrayInputStream(this.arrayResource), (OutputStream)os);
                        os.write(i);
                        IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                        this.arrayResource = null;
                    } else {
                        this.arrayResource = Arrays.copyOf(this.arrayResource, pos);
                    }
                }
                catch (IOException e) {
                    throw new AS2ExtensionException("Unexpected error while caching file stream", AS2ErrorType.STREAM, e);
                }
            }
        }

        @Override
        public InputStream asInputStream() {
            if (this.arrayResource != null) {
                return new ByteArrayInputStream(this.arrayResource);
            }
            if (this.fileResource != null) {
                try {
                    return new FileInputStream(this.fileResource);
                }
                catch (IOException e) {
                    throw new AS2ExtensionException("Unexpected error while reading file stream", AS2ErrorType.STREAM, e);
                }
            }
            return null;
        }

        static {
            File f;
            String s = System.getProperty("com.mulesoft.connectors.as2.CachedOutputStream.OutputDirectory");
            TEMP_FILE_DIR = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
            String v = System.getProperty("com.mulesoft.connectors.as2.CachedOutputStream.Threshold");
            DEFAULT_THRESHOLD = v == null ? -1 : Integer.parseInt(v);
        }
    }
}

