/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.stream;

import com.mulesoft.connectors.as2.internal.stream.BufferLoadingInputStream;
import com.mulesoft.connectors.as2.internal.stream.OutputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OutputTransformationInputStream
extends BufferLoadingInputStream {
    private OutputStream transformingOutputStream;

    public OutputTransformationInputStream(InputStream data, OutputStreamWrapper wrapper) throws IOException {
        super(data);
        this.transformingOutputStream = wrapper.wrap(new BufferOutputStream());
    }

    @Override
    public void loadBuffer(byte b) throws IOException {
        this.transformingOutputStream.write(b);
    }

    @Override
    protected void loadBuffer(byte[] b, int offset, int length) throws IOException {
        this.transformingOutputStream.write(b, offset, length);
    }

    @Override
    protected void endOfUnderlyingStream() throws IOException {
        this.transformingOutputStream.close();
    }

    private class BufferOutputStream
    extends OutputStream {
        private BufferOutputStream() {
        }

        @Override
        public void write(int b) {
            OutputTransformationInputStream.this.buffer.load((byte)b);
        }

        @Override
        public void write(byte[] b) {
            OutputTransformationInputStream.this.buffer.load(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            OutputTransformationInputStream.this.buffer.load(b, off, len);
        }
    }
}

