/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.stream;

import com.mulesoft.connectors.as2.internal.stream.Buffer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReplayInputStream
extends FilterInputStream {
    private Buffer buffer = new Buffer(1024);

    public ReplayInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val != -1) {
            this.buffer.load((byte)val);
        }
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        int val = super.read(b, off, length);
        this.buffer.load(b, off, length);
        return val;
    }

    public byte[] replay() {
        return this.buffer.readAll();
    }
}

