/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.crypto;

import com.mulesoft.connectors.as2.internal.crypto.EncryptionAlgorithmMapper;
import com.mulesoft.connectors.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connectors.as2.internal.error.AS2ErrorType;
import com.mulesoft.connectors.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connectors.as2.internal.stream.OutputTransformationInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OutputEncryptor;

public class PKCS7EncryptedEnvelopeStreamBuilder {
    private X509Certificate certificate;
    private EncryptionAlgorithm encryptionAlgorithm;
    private InputStream content;

    public PKCS7EncryptedEnvelopeStreamBuilder withCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public PKCS7EncryptedEnvelopeStreamBuilder withContent(InputStream content) {
        this.content = content;
        return this;
    }

    public InputStream build() {
        try {
            CMSEnvelopedDataStreamGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataStreamGenerator();
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(this.certificate));
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(EncryptionAlgorithmMapper.map(this.encryptionAlgorithm)).setProvider((Provider)new BouncyCastleProvider()).build();
            return new OutputTransformationInputStream(this.content, out -> {
                try {
                    return cmsEnvelopedDataGenerator.open(out, encryptor);
                }
                catch (CMSException e) {
                    throw new IOException(e);
                }
            });
        }
        catch (IOException | CertificateEncodingException | CMSException e) {
            throw new AS2ExtensionException("Error encrypting content with algorithm " + this.encryptionAlgorithm.name(), AS2ErrorType.ENCRYPTION, e);
        }
    }
}

