/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.error;

public enum DispositionType {
    PROCESSED(Status.PROCESSED, null, null),
    PROCESSED_WARNING_AUTHENTICATION_FAILED(Status.PROCESSED, Modifier.WARNING, "authentication-failed, processing continued"),
    PROCESSED_ERROR_AUTHENTICATION_FAILED(Status.PROCESSED, Modifier.ERROR, "authentication-failed"),
    PROCESSED_ERROR_DECRYPTION_FAILED(Status.PROCESSED, Modifier.ERROR, "decryption-failed"),
    PROCESSED_ERROR_DECOMPRESSION_FAILED(Status.PROCESSED, Modifier.ERROR, "decompression-failed"),
    PROCESSED_ERROR_INTEGRITY_CHECK_FAILED(Status.PROCESSED, Modifier.ERROR, "integrity-check-failed"),
    PROCESSED_ERROR_UNEXPECTED_PROCESSING_ERROR(Status.PROCESSED, Modifier.ERROR, "unexpected-processing-error"),
    FAILED_UNSUPPORTED_FORMAT(Status.FAILED, Modifier.FAILURE, "unsupported format"),
    FAILED_UNSUPPORTED_MIC_ALG(Status.FAILED, Modifier.FAILURE, "unsupported MIC-algorithms");

    private Status status;
    private Modifier statusModifier;
    private String statusDescription;

    private DispositionType(Status status, Modifier statusModifier, String statusDescription) {
        this.status = status;
        this.statusModifier = statusModifier;
        this.statusDescription = statusDescription;
    }

    public String getStatus() {
        return this.status.getStatus();
    }

    public String getStatusModifier() {
        return this.statusModifier.getModifier();
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    private static enum Modifier {
        WARNING("warning"),
        ERROR("error"),
        FAILURE("failure");

        private String modifier;

        private Modifier(String modifier) {
            this.modifier = modifier;
        }

        String getModifier() {
            return this.modifier;
        }
    }

    private static enum Status {
        PROCESSED("processed"),
        FAILED("failed");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        String getStatus() {
            return this.status;
        }
    }
}

