/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime;

import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.MimePartFinder;
import org.mule.runtime.api.util.MultiMap;

public class MDNReport
extends MimePart {
    private String originalRecipient;
    private String finalRecipient;
    private String originalMessageId;
    private String receivedContentMic;
    private String reportText;
    private MultiMap dispositionNotificationContent;
    private boolean processed;
    private byte[] digest;
    private HashAlgorithm digestAlgorithm;

    public void setDispositionNotificationContent(MultiMap dispositionNotificationContent) {
        this.dispositionNotificationContent = dispositionNotificationContent;
    }

    public MultiMap<String, String> getDispositionNotificationContent() {
        return this.dispositionNotificationContent;
    }

    public static MDNReport findMDNReport(MimePart mimePart) {
        return (MDNReport)new MimePartFinder(mp -> mp.getHeaders().getContentType() != null && mp.getHeaders().getContentType().toLowerCase().startsWith("message/disposition-notification")).find(mimePart);
    }

    public String getReceivedContentMic() {
        return this.receivedContentMic;
    }

    public void setReceivedContentMic(String receivedContentMic) {
        this.receivedContentMic = receivedContentMic;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public HashAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(HashAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public String getOriginalRecipient() {
        return this.originalRecipient;
    }

    public void setOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
    }

    public String getFinalRecipient() {
        return this.finalRecipient;
    }

    public void setFinalRecipient(String finalRecipient) {
        this.finalRecipient = finalRecipient;
    }

    public String getReportText() {
        return this.reportText;
    }

    public void setReportText(String reportText) {
        this.reportText = reportText;
    }
}

