/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.builder;

import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.error.DispositionType;
import com.mulesoft.connectors.as2.internal.mime.MimePart;
import com.mulesoft.connectors.as2.internal.mime.builder.MimePartBuilder;
import java.io.ByteArrayInputStream;
import java.util.Base64;

public class MDNMimePartBuilder
extends MimePartBuilder {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String MESSAGE_DISPOSITION_NOTIFICATION = "message/disposition-notification";
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String SEVEN_BIT = "7bit";
    private static final String REPORTING_UA_MULE4_AS2 = "Reporting-UA: Mulesoft AS2 connector\r\n";
    private static final String RFC_822 = "rfc822;";
    private String originalRecipient;
    private String finalRecipient;
    private String messageId;
    private byte[] digest;
    private HashAlgorithm digestAlgorithm;
    private DispositionType dispositionType;

    public MDNMimePartBuilder withOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
        return this;
    }

    public MDNMimePartBuilder withFinalRecipient(String finalRecipient) {
        this.finalRecipient = finalRecipient;
        return this;
    }

    public MDNMimePartBuilder withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public MDNMimePartBuilder withDigest(byte[] digest) {
        this.digest = digest;
        return this;
    }

    public MDNMimePartBuilder withDigestAlgorithm(HashAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public MDNMimePartBuilder withDispositionType(DispositionType dispositionType) {
        this.dispositionType = dispositionType;
        return this;
    }

    @Override
    public MimePart build() {
        MimePart mimePart = new MimePart();
        this.headers.put(CONTENT_TYPE, MESSAGE_DISPOSITION_NOTIFICATION);
        this.headers.put(CONTENT_TRANSFER_ENCODING, SEVEN_BIT);
        mimePart.setHeaders(this.headers);
        String receivedContentMic = "";
        if (this.digest != null && this.digestAlgorithm != null) {
            receivedContentMic = "Received-Content-MIC: " + Base64.getEncoder().encodeToString(this.digest) + ", " + (Object)((Object)this.digestAlgorithm) + "\r\n";
        }
        if (this.dispositionType == null) {
            this.dispositionType = DispositionType.PROCESSED;
        }
        String statusModifierDescription = "";
        statusModifierDescription = this.dispositionType != DispositionType.PROCESSED ? this.dispositionType.getStatus() + "/" + this.dispositionType.getStatusModifier() + ": " + this.dispositionType.getStatusDescription() : this.dispositionType.getStatus();
        String mdnContent = "Reporting-UA: Mulesoft AS2 connector\r\nOriginal-Recipient: rfc822; " + this.originalRecipient + "\r\nFinal-Recipient: " + RFC_822 + " " + this.finalRecipient + "\r\nOriginal-Message-ID: " + this.messageId + "\r\nDisposition: automatic-action/MDN-sent-automatically; " + statusModifierDescription + "\r\n" + receivedContentMic + "\r\n";
        this.content = new ByteArrayInputStream(mdnContent.getBytes());
        mimePart.setContent(this.content);
        return mimePart;
    }
}

