/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.as2.internal.mime.parse;

import com.mulesoft.connectors.as2.internal.codec.Encoding;
import com.mulesoft.connectors.as2.internal.enums.HashAlgorithm;
import com.mulesoft.connectors.as2.internal.mime.MDNReport;
import com.mulesoft.connectors.as2.internal.mime.MimeHeaders;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeContentParser;
import com.mulesoft.connectors.as2.internal.mime.parse.MimeParserController;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNReportParser
implements MimeContentParser<MDNReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDNReportParser.class);
    private static final Pattern MESSAGE_ID_PATTERN = Pattern.compile("\r\n[ \t]*Original-Message-ID[ \t]*:[ \t]*(?<originalMessageId>[^ \t\r\n]*)[ \t]*\r\n", 2);
    private static final Pattern DIGEST_PATTERN = Pattern.compile("\r\n[ \t]*Received-Content-MIC[ \t]*:[ \t]*(?<MIC>[^, \t\r\n]*).*\r\n", 2);
    private static final Pattern DIGEST_ALGORITHM_PATTERN = Pattern.compile("\r\n[ \t]*Received-Content-MIC[ \t]*:.*,[ \t]*(?<MICalg>[^ \t\r\n]*)?[ \t]*\r\n", 2);
    private static final Pattern PROCESSED_PATTERN = Pattern.compile("\r\n[ \t]*Disposition[ \t]*:(?<processed>.*)\r\n", 2);
    private static final Pattern ORIGINAL_RECIPIENT = Pattern.compile("\r\n[ \t]*Original-Recipient[ \t]*:.*;[ \t]*(?<originalRecipient>[^ \t\r\n]*)?[ \t]*\r\n", 2);
    private static final Pattern FINAL_RECIPIENT = Pattern.compile("\r\n[ \t]*Final-Recipient[ \t]*:.*;[ \t]*(?<finalRecipient>[^ \t\r\n]*)?[ \t]*\r\n", 2);

    @Override
    public boolean canParseContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("message/disposition-notification");
    }

    @Override
    public boolean digestRequired() {
        return false;
    }

    @Override
    public MDNReport parse(MimeHeaders mimeHeaders, InputStream is, MimeParserController mimeParserController) {
        String reportContent = this.extractDispositionNotification(mimeHeaders, IOUtils.toString((InputStream)is));
        MDNReport report = new MDNReport();
        report.setDispositionNotificationContent(this.getDispositionNotificationContent(reportContent));
        report.setOriginalMessageId(this.getOriginalMessageId(reportContent));
        report.setDigest(this.getDigest(reportContent));
        report.setReceivedContentMic(this.getReceivedContentMic(reportContent));
        report.setDigestAlgorithm(this.getDigestAlgorithm(reportContent));
        report.setProcessed(this.getProcessed(reportContent));
        report.setOriginalRecipient(this.getOriginalRecipient(reportContent));
        report.setFinalRecipient(this.getFinalRecipient(reportContent));
        report.setHeaders(mimeHeaders);
        report.setReportText(reportContent);
        return report;
    }

    private MultiMap getDispositionNotificationContent(String reportContent) {
        String[] contentRows;
        MultiMap dispositionNotificationContent = new MultiMap();
        for (String row : contentRows = reportContent.split("\r\n")) {
            String[] rowParts = row.split(":", 2);
            String[] splitRowContent = rowParts[1].split("[;,]");
            dispositionNotificationContent.put((Object)rowParts[0], Arrays.stream(splitRowContent).map(String::trim).collect(Collectors.toList()));
        }
        return dispositionNotificationContent;
    }

    private String extractDispositionNotification(MimeHeaders mimeHeaders, String content) {
        Encoding encodingType;
        if (mimeHeaders.getContentTransferEncoding() != null && (encodingType = Encoding.getEncodingForType(mimeHeaders.getContentTransferEncoding())) != null) {
            LOGGER.debug("Decoding the message/disposition-notification from encoding {}", (Object)encodingType.toString());
            byte[] decode = encodingType.decode(content);
            return new String(decode);
        }
        return content;
    }

    private String getOriginalRecipient(String content) {
        Matcher m = ORIGINAL_RECIPIENT.matcher(content);
        if (m.find()) {
            return m.group("originalRecipient");
        }
        LOGGER.warn("Unable to parse original recipient in MDN report");
        return "";
    }

    private String getFinalRecipient(String content) {
        Matcher m = FINAL_RECIPIENT.matcher(content);
        if (m.find()) {
            return m.group("finalRecipient");
        }
        LOGGER.warn("Unable to parse final recipient in MDN report");
        return "";
    }

    private String getOriginalMessageId(String content) {
        Matcher m = MESSAGE_ID_PATTERN.matcher(content);
        if (m.find()) {
            return m.group("originalMessageId");
        }
        LOGGER.warn("Unable to parse message id in MDN report");
        return "";
    }

    private byte[] getDigest(String content) {
        Matcher m = DIGEST_PATTERN.matcher(content);
        if (m.find()) {
            String digest = m.group("MIC");
            try {
                return Base64.getMimeDecoder().decode(digest);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unable to parse digest in MDN report of {}", (Object)digest);
            }
        } else {
            LOGGER.warn("Unable to parse digest in MDN report");
        }
        return null;
    }

    private HashAlgorithm getDigestAlgorithm(String content) {
        Matcher m = DIGEST_ALGORITHM_PATTERN.matcher(content);
        if (m.find()) {
            String algorithm = m.group("MICalg");
            try {
                return HashAlgorithm.valueOf(algorithm);
            }
            catch (IllegalArgumentException iae) {
                HashAlgorithm algEnum = HashAlgorithm.findByAlgorithm(algorithm);
                if (algEnum != null) {
                    return algEnum;
                }
                LOGGER.warn("Unable to parse digest algorithm in MDN report of {}", (Object)algorithm);
            }
        } else {
            LOGGER.warn("Unable to parse digest algorithm in MDN report");
        }
        return null;
    }

    private String getReceivedContentMic(String content) {
        Matcher m = DIGEST_PATTERN.matcher(content);
        if (m.find()) {
            return m.group("MIC");
        }
        LOGGER.warn("Unable to parse digest in MDN report");
        return null;
    }

    private boolean getProcessed(String content) {
        Matcher m = PROCESSED_PATTERN.matcher(content);
        if (m.find()) {
            return m.group("processed").toLowerCase().trim().endsWith("processed");
        }
        LOGGER.warn("Unable to parse processed status in MDN report");
        return false;
    }
}

